/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.placement.recruitmentStage.PlacementRecruitmentStageGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementrecruitmentstagegrid',
	store: 'placement.recruitmentStage.PlacementRecruitmentStageGridStore',
	title: getCommonTranslation('RECRUITMENT_PROCESS'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'placementrecruitmentstagestructure':1
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.recruitmentStage.PlacementRecruitmentStageGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		text: getPlacementTranslation('ENTER_MARKS'),
		itemId: 'enterMarks'
	}, {
		xtype: 'button',
		text: getPlacementTranslation('PROMOTE_STUDENT'),
		itemId: 'promoteStudent'
		//hidden:true,
	}, {
		xtype: 'button',
		text: getPlacementTranslation('CALCULATE_RANK'),
		itemId: 'calculateRank'
	},{
		xtype: 'button',
		text: getPlacementTranslation('PLACEMENT_APP_SEND_MSG'),
		itemId: 'sendMessage'
		//buttonAlign: 'left',
	}],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getCourseTxCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getCourseTxCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getCourseTxCommonTranslation('Program'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCourseTxCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCourseTxCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('SELECTION_PROCCESS'),
		dataIndex: 'selectionProcessName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('SELECTION_STAGE'),
		dataIndex: 'selectionStageName',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('MARKS'),
		dataIndex: 'marks',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('RANK'),
		dataIndex: 'rank',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('STATUS'),
		dataIndex: 'status',
		flex:.1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return capitaliseEnumValue(value);
			else 
				return '';
		}
	}]
});

