/**
 * Raghavendra.Soni
 */
Ext.define('Academia.view.prereqnotmetreport.PreReqNotMetReportGrid' ,{   
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.prereqnotmetreportgrid',
    store: 'common.PreReqNotMetReportStore',
    title: getCommonTranslation('LIST_OF_PRE_REQUISITE_NOT_MET_STUDENTS'),
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'prereqnotmetreportstructure':1
		}
	},
    /*dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store: 'common.PreReqNotMetReportStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],*/
    initComponent: function() {
        var grid=this;          
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
    },
    columns: [{
        header: getCommonTranslation('ADMISSION_ID'),
        dataIndex: 'admissionId',
        sortable:true,
        flex: .2
    },{
        header: getCommonTranslation('STUDENT_ID_NAME'),
        dataIndex: 'studentIdName',
        sortable:true,
        flex: .2
    }, {
        header: getCommonTranslation('SU_NUMBER'),
        dataIndex: 'suNumber',
        sortable: true,
        flex: .2
    },{
        header: getCommonTranslation('PROGRAM_CODE'),
        dataIndex: 'programCode',
        sortable:true,
        flex: .2
    }, {
        header: getCommonTranslation('PROGRAM_NAME'),
        dataIndex: 'programName',
        sortable:true,
        flex: .2
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable:true,
        flex: .2
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable:true,
        flex: .2
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        sortable:true,
        flex: .2
    }, {
        header: getCommonTranslation('PREREQUISITE_COURSE_CODE_WITH_OBTAINED_MARKS'),
        dataIndex: 'courseAndMarksMapString',
        sortable:true,
        flex: .2,
        renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			if(value){
				return '<a href="#">View</a>'; //preRequisiteJson, coRequisiteJson
			}
			else{
				return "";
			}
		}
    }, {
        header: getCommonTranslation('COURSE_CODE_DE_ENROLL'),
        dataIndex: 'courseCodetoDeenroll',
        sortable:true,
        flex: .2
    }, {
        header: getCommonTranslation('PRE_REQUISITE'),
        dataIndex: 'preRequisiteJson',
        sortable:true,
        flex: .2,
        renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			if(value){
				return '<a href="#">View</a>'; //preRequisiteJson, coRequisiteJson
			}
			else{
				return "";
			}
		}
    }]

});