/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.program.OutcomeBasedEducationGrid.ProgramOutcomeIndirectAttainmentGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.programoutcomeindirectattainmentgrid',
    store: 'program.ManageProgramOutcomeStore',
    title: getExaminationTranslation('LIST_OF_PROGRAM_OUTCOMES_AND_INDIRECT_ATTAINMENT'),   
    border: true,
    autoScroll:false,
    frame: true,
	cls:"titleCenterAlign",
    minHeigh:400,
    maxHeight:400,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			itemId: 'attainmentSaveBtn',
			ui: 'CustomBtnSubmit',
			text: getCommonTranslation('SAVE'),
			disabled:true
			
		 }]
		}],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getProgramandcourseTranslation('PROGRAM_OUTCOME_CODE'),
        dataIndex: 'programOutComeCode',
        flex: 0.5,
        sortable: false,
        menuDisabled:true,
        editor: {
        	xtype: 'textfield',
        	name: 'programOutComeCode',
        	width:50,
        	minValue:0,
        	maxLength: 15,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	itemId: 'programOutComeCode',
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
        
    },{
        header: getExaminationTranslation('INDIRECT_ATTIANMENT'),
        dataIndex: 'indirectAttainment',
        flex: 0.5,
        sortable: false,
        menuDisabled:true,
        editor: {
        	xtype: 'numberfield',
        	name: 'indirectAttainment',
        	width:50,
        	allowDecimals:true,
			minValue:0,
			maxValue:100,
			decimalPrecision: 2,
        	itemId: 'indirectAttainment',
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    },],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
    listeners: {
    	beforeedit: function(editor, context) {
    		if(editor.context.field=='programOutComeCode'){
    				context.grid.columns[0].getEditor().setReadOnly(true);

    		}
    	}
	}
});
