/**
 * @Author Akshay Sharma
 */
Ext.define('Academia.view.program.SpecializationList', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.specializationlist',
	store : 'program.SpecializationListStore',
	title: getProgramandcourseTranslation('SPECIALIZATION_LIST'),
	border: true,
	specialTemp :[],
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.SpecializationListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this; 
		this.callParent(arguments);
	},
	columns : [{
		header :getCommonTranslation('SPECIALIZATION_CODE'),
		dataIndex : 'specializationCode',
		flex:1
	},{
		header :getCommonTranslation('SPECIALIZATION_NAME'),
		dataIndex : 'specializationName',
		flex:1
	},{
		header : getProgramandcourseTranslation('NO_OF_ASSOCIATED_COURSE_GROUP'),
		dataIndex : 'noOfAssociatedCourseGroups',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('NO_OF_ASSOCIATED_COURSES'),
		dataIndex : 'noofAssociatedCourses',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('STATUS'),
		dataIndex : 'status',
		flex:1,
		hidden:true
	}]
});
