/*
 * #author: Raghavendra.Soni
 */
Ext.define('Academia.view.program.programDetails.ProgramOtherDetailsFrom' ,{
	extend : 'Academia.view.common.DynamicFieldForm',
	alias : 'widget.programotherdetailsfrom',
	itemId:'programOtherDetailsFormItemId',
    cls: 'horizontalScrollingFixed',
    frame: false,
    title: getCommonTranslation('PROGRAM_OTHER_DETAILS'),
	modal: true,
	autoScroll: false,
    method: 'POST',
    border: true,
    
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    layout: {
        type: 'vbox'
    },
    standardSubmit: false,
    defaults: {
        labelAlign: 'top'
    },
    plugins:"formlabelrequired",
	items:[{
		xtype:'fieldset',
		layout:'vbox',
		frame:true,	
		width:'100%',
		itemId : 'programOtherDetailsFieldSettemId',
		style:{
			'margin-top': '0px !important',
			'padding-top': '0px !important'
		},
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 250,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'customcombobox',
	            name: 'programCollaborationCertificate',
	            fieldLabel: getCommonTranslation('PROGRAM_COLLABORATION_CERTIFICATE'),
	            store:'common.ProgramCollaborationCertificateStore',
	            displayField:'translatedValue',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
	        },{
	        	xtype: 'customcombobox',
	            name: 'qualModeOfOffering',
	            fieldLabel: getCommonTranslation('QUAL_MODE_OF_OFFERING'),
	            store:'common.ProgramModeOfferingStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
	        },{
	        	xtype:'textfield',
	        	name: 'qualGraduationSequence',
	        	fieldLabel: getCommonTranslation('QUAL_GRADUATION_SEQUENCE'),
	        	itemId:'qualGraduationSequence',
				maxLength: 55
	        },{
	        	xtype: 'numberfield',
	            fieldLabel: getCommonTranslation('EXEMPTED_CREDIT_LIMIT'),  
	            name: 'exemptedCreditLimit',
	            itemId: 'exemptedCreditLimitId',
	            hideTrigger: true,
	            keyNavEnabled: false,
	            mouseWheelEnabled: false,
	            maxLength:5,
	            hidden:true,
	            allowExponential: false,
	            minValue:0
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 250,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'customcombobox',
	            name: 'qualHeqsfType',
	            fieldLabel: getCommonTranslation('QUAL_HEQSF_TYPE'),
	            store:'common.ProgramHEQSFTypeStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			},{
				xtype: 'numberfield',
				name: 'qualHeqsfType2015',
				fieldLabel: getCommonTranslation('QUAL_HEQSF_TYPE_2015'),
				maxLength: 3,
				minValue: 0
			},{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('QUAL_ALIGNED'),
				itemId: 'qualAligned',
				name: 'qualAligned',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'qualAligned', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'qualAligned', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('POST_GRADUATE_FIN_AID_ELIGIBLE'),
				itemId: 'finAidEligible',
				name: 'finAidEligible',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'finAidEligible', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'finAidEligible', 
					inputValue: false,
					checked:true
				}]
			}]
		 },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 250,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'customcombobox',
	            name: 'qualNqfLevel',
	            fieldLabel: getCommonTranslation('QUAL_LQF_LEVEL'),
	            store:'common.ProgramNqfLevelStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			},{
				xtype: 'numberfield',
				name: 'qualNqfCreditsTotal',
				fieldLabel: getCommonTranslation('QUAL_NQF_CREDITS_TOTAL'),
				minValue: 0,
				maxValue: 9999
			}, {
				xtype: 'numberfield',
				name: 'qualNqfCreditsWilEl',
				fieldLabel: getCommonTranslation('QUAL_NQF_CREDITS_WIL_EL'),
				minValue: 0,
				maxValue: 9999
			}, {
				xtype: 'numberfield',
				name: 'qualNqfCreditsResearch',
				fieldLabel: getCommonTranslation('QUAL_NQF_CREDITS_RESEARCH'),
				minValue: 0,
				maxValue: 9999
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 250,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textfield',
				name: 'qualHemisWilElDuration',
				fieldLabel: getCommonTranslation('QUAL_HEMIS_WIL_EL_DURATION'),
				maxLength: 5
			},{
				xtype: 'textfield',
				name: 'qualHemisSubsidyUnits',
				fieldLabel: getCommonTranslation('QUAL_HEMIS_SUBSIDY_UNITS'),
				maxLength: 5
			},{
	        	xtype: 'customcombobox',
	            name: 'qualHemisSubsidyFundingLevel',
	            fieldLabel: getCommonTranslation('QUAL_HEMIS_SUBSIDY_FUNDING_LEVEL'),
	            store:'common.ProgramSubsidyFundingLevelStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			},{
	        	xtype: 'customcombobox',
	            name: 'qualHemisSubsidyFundingLevelAdd',
	            fieldLabel: getCommonTranslation('QUAL_HEMIS_SUBSIDY_FUNDING_LEVEL_ADD'),
	            store:'common.ProgramSubsidyFundingLevelAddStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 250,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'datefield',
	            anchor: '100%',
	            fieldLabel: getCommonTranslation('QUAL_APPROVAL_DATE'),
	            name: 'qualApprovalDate',
	            itemId:'qualApprovalDate',
				vtype : 'daterange',
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);
					}
				},
	        },{
	        	xtype: 'numberfield',
	        	name: 'qualMinDurationTime',
	        	itemId: 'qualMinDurationTime',
	        	fieldLabel: getCommonTranslation('QUAL_MIN_DURATION_TIME'),
	        	maxLength: 5, // Includes decimal point and two decimal places
	        	minValue: 0,
	        	maxValue: 100,
	        	decimalPrecision: 2, // Allows up to two decimal places
	        	enforceMaxLength: true
			},{
				xtype: 'numberfield',
				name: 'qualMaxDurationTime',
				itemId: 'qualMaxDurationTime',
				fieldLabel: getCommonTranslation('PROGRAM_MAX_DURATION_TIME'),
				maxLength: 5, // Includes decimal point and two decimal places
	        	minValue: 0,
	        	maxValue: 100,
	        	decimalPrecision: 2, // Allows up to two decimal places
	        	enforceMaxLength: true
			},{
				xtype: 'numberfield',
				name: 'qualMinExperienceTime',
				fieldLabel: getCommonTranslation('QUAL_MIN_EXPERIENCE_TIME'),
				maxLength: 5, // Includes decimal point and two decimal places
	        	minValue: 0,
	        	maxValue: 100,
	        	decimalPrecision: 2, // Allows up to two decimal places
	        	enforceMaxLength: true
			}]
		 },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 250,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'numberfield',
				name: 'qualMinFormalTime',
				fieldLabel: getCommonTranslation('QUAL_MIN_FORMAL_TIME'),
				maxLength: 5, // Includes decimal point and two decimal places
	        	minValue: 0,
	        	maxValue: 100,
	        	decimalPrecision: 2, // Allows up to two decimal places
	        	enforceMaxLength: true
			},{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('QUAL_EXTENDED_PROGRAMME'),
				itemId: 'qualExtendedProgramme',
				name: 'qualExtendedProgramme',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'qualExtendedProgramme', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'qualExtendedProgramme', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('QUAL_EXTENDED_PROGRAMME_SUBSIDIZED'),
				itemId: 'qualExtendedProgrammeSubsidized',
				name: 'qualExtendedProgrammeSubsidized',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'qualExtendedProgrammeSubsidized', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'qualExtendedProgrammeSubsidized', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('QUAL_PQM_REPORT'),
				itemId: 'qualPQMReport',
				name: 'qualPQMReport',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'qualPQMReport', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'qualPQMReport', 
					inputValue: false,
					checked:true
				}]
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 250,
				labelAlign : 'top'
			},
			items : [{
	        	xtype: 'customcombobox',
	            name: 'qualCesmClassification',
	            fieldLabel: getCommonTranslation('QUAL_CESM_CLASSIFICATION'),
	            store:'common.ProgramCesmClassificationStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('QUAL_FIRST_OFFERING_DATE'),
				name : 'qualFirstOfferingDate',
				itemId : 'qualFirstOfferingDate',
				endDateField : 'qualLastOfferingDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('QUAL_LAST_OFFERING_DATE'),
				name : 'qualLastOfferingDate',
				itemId : 'qualLastOfferingDate',
				startDateField : 'qualFirstOfferingDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange'
			},{
				xtype: 'numberfield',
				name: 'qualMinDurationApprovedFullTime',
				fieldLabel: getCommonTranslation('QUAL_MIN_DURATION_APPROVED_FULL_TIME'),
				maxLength: 5, // Includes decimal point and two decimal places
	        	minValue: 0,
	        	maxValue: 100,
	        	decimalPrecision: 2, // Allows up to two decimal places
	        	enforceMaxLength: true
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 250,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'numberfield',
				name: 'qualMinDurationApprovedPartTime',
				fieldLabel: getCommonTranslation('QUAL_MIN_DURATION_APPROVED_PART_TIME'),
				maxLength: 5, // Includes decimal point and two decimal places
	        	minValue: 0,
	        	maxValue: 100,
	        	decimalPrecision: 2, // Allows up to two decimal places
	        	enforceMaxLength: true
			},{
	        	xtype:'textfield',
	        	name: 'programFocalAreaAfrikaans',
	        	fieldLabel: getCommonTranslation('PROGRAM_FOCAL_AREA_AFRICANS'),
	        	itemId:'programFocalAreaAfrikaans',
				maxLength: 100
	        },{
	        	xtype:'textfield',
	        	name: 'programFocalAreaEnglish',
	        	fieldLabel: getCommonTranslation('PROGRAM_FOCAL_AREA_ENGLISH'),
	        	itemId:'programFocalAreaEnglish',
				maxLength: 100
	        },{
	        	xtype:'textfield',
	        	name: 'programFocalAreaXhosa',
	        	fieldLabel: getCommonTranslation('PROGRAM_FOCAL_AREA_XHOSA'),
	        	itemId:'programFocalAreaXhosa',
				maxLength: 100
	        }
			]
		},
		{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 250,
				labelAlign : 'top'
			},
			items : [{
	        	xtype: 'customcombobox',
	            name: 'programGroupFinance',
	            fieldLabel: getCommonTranslation('PROGRAM_GROUP_FINANCE'),
	            store:Ext.create('Academia.store.common.ProgramGroupFinanceStore'),
                itemId:'programGroupFinance',
                displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
	        },{
	        	xtype:'textfield',
	        	name: 'programCollaborationCertTextEng',
	        	fieldLabel: getCommonTranslation('PROGRAM_COLLABORATION_CERT_TEXT_ENG'),
	        	itemId:'programCollaborationCertTextEngId'
				
	        },{
	        	xtype:'textfield',
	        	name: 'programCollaborationCertTextAfr',
	        	fieldLabel: getCommonTranslation('PROGRAM_COLLABORATION_CERT_TEXT_AFR'),
	        	itemId:'programCollaborationCertTextAfrId'
				
	        },{
	        	xtype:'textfield',
	        	name: 'programCollaborationCertTextXhosa',
	        	fieldLabel: getCommonTranslation('PROGRAM_COLLABORATION_CERT_TEXT_ENG_XHOSA'),
	        	itemId:'programCollaborationCertTextXhosaId'
				
	        }]
		}]
    },{
    	xtype:'fieldcontainer',
    	width:'100%',
    	layout : {
    		type : 'hbox'
    	},
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SAVE'),
    		itemId: 'programOtherDetailFormSubmitButtonId',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true,
	    	style:{
	    		'margin-left':'10px !important'
	    	}
    	},{
 		   xtype: 'button',
		   text: getCourseTxCommonTranslation('RESET'),
		   itemId: 'resetBtn',
		   buttonAlign: 'left',
		   ui: 'CustomBtnCancel',
		   scale: CONSTANTS.BUTTONSIZE
	   }]
    }]
});