/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.courseFeeDefinition.ViewCourseFeeDefinitionGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.viewcoursefeedefinitiongrid',
	store : 'feeandpayment.coursefeedefinition.CourseFeeSubHeadStore',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.coursefeedefinition.CourseFeeSubHeadStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},

	columns: [{
		header:  getCommonTranslation('SERIAL_NO'),
		dataIndex: 'serialNo',
		flex:.1,
		sortable: false,

	},{
		header:  getCommonTranslation('SUB_HEAD'),
		dataIndex: 'feeHeadName',
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('AMOUNT/WEIGHTAGE'),
		dataIndex: 'amountOrWeightage',
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('COST_CENTER'),
		dataIndex: 'costCentre',
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('REFUNDABLE'),
		dataIndex: 'isRefundable',
		flex:.1,
		sortable: false,
		renderer : function(value){
			if(value){
				return 'Yes';
			}
			else{
				return 'No';
			}
		}

	},{
		header:  getCommonTranslation('REFUND_RULE'),
		dataIndex: 'rulePrintName',
		flex:.1,
		sortable: false,

	},
	{
		header:  getCommonTranslation('DISCOUNT_RULE'),
		dataIndex: 'discountRulePrintName',
		flex:.1,
	    sortable: false,
	   
	}
	] 	
});
