Ext.define('Academia.view.program.programDetails.programBatchDetails.courseParameters.AddFacultyGrid', {
    extend : 'Ext.grid.Panel',
    alias : 'widget.addfacultygrid',
    store : 'program.programDetails.programBatches.courseParameter.FacultyData',
    title : getCommonTranslation('FACULTY_LIST'),
    border: true,
    isGridConfigurable: true,
	enableColumnHide: false,
    autoScroll: false,
    overflowY: 'auto',
  //  id:'programCourseGroupsGridId',
   // selModel: sm, 
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [ {
	xtype : 'toolbar',
	dock : 'bottom',
	items : [ {
	    xtype : 'custompagingtoolbar',
	    plugins:['pagesize'],
	    store : 'program.programDetails.programBatches.courseParameter.FacultyData',
	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    displayInfo : true
	} ]
    }
    ],
    tbar: [{
		xtype : 'button',				
		itemId : 'facultybtnEditItemId',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'facultybtnDeleteItemId',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns : [{
	    header :getCommonTranslation('FACULTY_CODE'),
	    dataIndex : 'facultyCode',
	    flex : .1,
	    sortable : true,
	    renderer : function(value,records) {
			if(!isNullOrEmpty(records.record.data.facultyCode) && !isNullOrEmpty(records.record.data.facultyName)){
				return records.record.data.facultyCode+"/"+records.record.data.facultyName;
			}
		}
	}, {
	    header : getCommonTranslation('ALTERNATE_FACULTY_CODE'),
	    dataIndex : 'alternatFacultyCode',
	    flex : .1,
	    sortable : true,
	    renderer : function(value,records) {
	    	if(!isNullOrEmpty(records.record.data.alternatFacultyCode) && !isNullOrEmpty(records.record.data.alternatfacultyName)){
				return records.record.data.alternatFacultyCode+"/"+records.record.data.alternatfacultyName;
			}
		}
	}/*, {
	    header : getCommonTranslation('FACULTY_TYPE'),
	    dataIndex : 'facultyType',
	    flex : .1,
	    sortable : true
	}  */  
	]

});
 
