/**
 * @author Utsav Chandvaniya
 */
Ext.define('Academia.view.programCourseDashboard.TopBottonProgramAbsenteeismSearch', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.topbottonprogramabsenteeismsearch',
	autoScroll: false,
	frame: false,
	border:false,
	itemId:'topbottonprogramabsenteeismsearchPanel',
	cls:'panelNoSpace',
	items: [{
		xtype: 'form',
		frame: false,
		border:false,
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			cls:'panelNoSpace',
			items:[{
				xtype:'panel',
				width:'100%',
				cls:'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					itemId:'topOrBottomAttendanceId',				
					columns: 2,
					vertical: false,				
					items: [
					        { boxLabel: getProgramandcourseTranslation('TOP_ABSENTEEISM'), name: 'topOrBottomAttendance', inputValue: 'TOP_ABSENTEEISM',checked:true},
					        { boxLabel: getProgramandcourseTranslation('BOTTOM_ABSENTEEISM'), name: 'topOrBottomAttendance', inputValue: 'BOTTOM_ABSENTEEISM'}
					        ]
				}]
			}]
		},{		
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults :{
				labelAlign:'top',
				width:226
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
//				translationKey: 'PROGRAM',
				name : 'programId',
				itemId : 'programId',      	   
				store : 'common.ProgramsByAcademyLocationsIds',
				displayField : 'valueCode',
				valueField : 'id',
				typeAhead : false,
				forceSelection : true,
				//allowBlank : false,
				hidden : false,
				//queryMode:'local' ,
				queryParam: 'programName',
			    minChars: 3,
			    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    listConfig: {
	                listeners: {
	                    beforeshow: function(
	                        picker) {
	                        picker.minWidth = picker
	                            .up('combobox')
	                            .getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code} / {value}' +
	                        '</div>';
	                }
	            }
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),		
				name : 'batchId',
				itemId : 'batchId',
				store : 'enquiry.AcademicBatchStore',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				hidden : false
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),
				name : 'periodId',
				itemId : 'periodId',
				store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				hidden : false
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',	              
				name: 'attendancePercentage',
				itemId:'attendancePercentage',
				maxValue:100,
				minValue:0,
				mouseWheelEnabled :false,
				hideTrigger :true,
				labelAlign:'top',
				width:226,
				fieldLabel: getProgramandcourseTranslation('ABSENTEEISM_PERCENTAGE')
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',

			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'btnSearch',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE               
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'btnReset',
				// buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}
		]
	},{
		xtype:'panel',
		items:[{
			xtype:'searchresultgrid',
			width:'100%',
			title :getProgramandcourseTranslation('TOP_AND_BOTTOM_PROGRAM_ABSENTEEISM'),
			itemId:'topbottomprogramabsenteeismgrid',
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		}]
	}]
});