/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.receipt.receiptsettings.PaymentTermConfigureFeeHeadWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.paymenttermconfigurefeeheadwin',
    title: getFeeAndPaymentCommonTranslation('CONFIGURE_FEE_HEAD'),
    modal: true,
    autoScroll: true,
    items: [{
        xtype: 'form',
        itemId: 'configureFeeHeadFormItemId',
        method: 'POST',
        defaults: {
            labelAlign: 'top',
        },
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'hidden',
                name: 'id',
                itemId:'id'
            }, {
            	xtype:'hidden',
            	name:'tempId',
            	itemId:'tempId'
            },{
                xtype: 'customcombobox',
                name: 'feeHead',
                itemId: 'feeHeadId',
                fieldLabel: getFeeAndPaymentCommonTranslation('FEES_HEADS'),
                store: 'sponsorship.ManageConfiguredFeeHeadsStore',
    			valueField: 'id',
    			displayField: 'feeHeadName',
                allowBlank: false,
                typeAhead: false,
                editable:false
            },{
                xtype: 'customcombobox',
                name: 'costCenter',
                itemId: 'costCenterId',
                fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTER'),
                store: 'feeandpayment.CostCenterConfig',
    			valueField: 'id',
    			displayField: 'value',
                typeAhead: false,
                editable:false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
            	 width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'numberfield',
                name: 'amountOrWeightage',
                itemId: 'weightageId',
                fieldLabel: getCommonTranslation('WEIGHTAGE'),
                allowBlank: false,
                keyNavEnabled: false,
                mouseWheelEnabled: false,
                minValue: 1,
                maxValue: 100,     
                enforceMaxLength: true,
                maxLength: 3,       
                allowExponential: false,
                allowDecimals: false,
                hideTrigger: true,
            },{
				xtype:'checkbox',
				name:'discount',
				itemId:'discountId',
				boxLabel:getFeeAndPaymentCommonTranslation('DISCOUNT'),
				labelAlign: 'right',
				inputValue: true,
				style:{
					marginTop:'25px !important'
				}
			}]
        },{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
            	 width: 226,
                labelAlign: 'top'
            },
            items: [{
        		xtype: 'customcombobox',
        		name: 'discountFeehead',
        		itemId:'discountFeeheadId',
        		fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_FEE_HEAD'),
        		store: 'feeandpayment.discount.DiscountFeeHeadStore',
        		valueField: 'id',
        		displayField: 'value',
        		minChars:3,
        		queryParam:'qry',
        		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		typeAhead:true,
        		forceSelection:true,
        		hidden:true
            },{
            	xtype: 'customcombobox',
            	name: 'discountApplicability',
            	itemId:'discountApplicabilityId',
            	fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_APPLICABILITY'),
            	store: 'feeandpayment.DiscountType',
        		valueField: 'id',
        		displayField: 'value',
            	typeAhead:true,
            	forceSelection:true,
            	hidden:true,
            	editable:false
            }]
        },{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
            	 width: 226,
                labelAlign: 'top'
            },
            items: [{
    			xtype: 'customcombobox',
    			name: 'discountCostCentre',
    			itemId:'discountCostCentreId',
    			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_COST_CENTER'),
    			store: 'feeandpayment.CostCenterConfig',
    			valueField: 'id',
    			displayField: 'value',
    			minChars:3,
    			hidden:true,
    			queryParam:'qry',
    			listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.width = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    
                },
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			typeAhead:true,
    			forceSelection:true
    		}]
        },{
        	 xtype: 'fieldcontainer',
             width: 'auto',
             layout: {
                 type: 'hbox'
             },
             defaults: {
             	 width: 226,
                 labelAlign: 'top'
             },
             items: [{
         		xtype: 'textareafield',
        		name: 'remark',
        		width:460,
        		itemId:'remarkId',
        		fieldLabel: getFeeAndPaymentCommonTranslation('REMARKS'),
        		enforceMaxLength : true,
        		maxLength:300
        	}]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveItemId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancelItemId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});