/**
 * @author Varsha Gour
 *
 */
Ext.define('Academia.view.receipt.receiptsettings.ReceiptSettingsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.receiptsettingsgrid',
    store: 'receipt.receiptsettings.ReceiptSettingsStore',
    title: getCommonTranslation('RS_RECEIPT_SETTINGS'),
    border: true,
    autoScroll: false,
    sortable: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'receipt.receiptsettings.ReceiptSettingsStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocation',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value) && !isNullOrEmpty(value.value)) {
                return value.value;
            }
            return '';
        }
    }, {
        header: getCommonTranslation('RS_BACK_DATE_DAYS'),
        dataIndex: 'numberOfDays',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('ALLOW_AMOUNT_VALUE_IN_DECIMAL'),
        dataIndex: 'allowAmountValueInDecimal',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value) && value == true) {
                return 'Yes';
            }else{
            	return 'No';
            }
        }
        
    }]
});