/**
 * 
 */
Ext.define('Academia.view.registrationsetup.RegistrationSetupDocumentGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.registrationsetupdocumentgrid',
	store: 'documentmanagement.DocumentMasterStore',
	border: true,
	autoScroll: false,
	cls:'clsAssigneeApproverGrid',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	style:{
		marginLeft:'0px'
	},
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : true
	},
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header: getCommonTranslation("DOCUMENT_NAME"),
		dataIndex: 'value',
		flex:1,
		sortable:false,
	},{
		xtype:'checkcolumn',
		header:getCommonTranslation('MANDATORY'),
		flex:1,
		sortable:false,
		dataIndex : 'mandatory',
		renderer: function(value, metadata,record) {
			var data=record.data;
			if(data.moduleName != 'Program Details'){
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			}
		},
		listeners:{
			checkchange : function( column, rowIndex, checked, eOpts ){
			var view = column.up('grid');
			var selected =  view.getSelectionModel().isSelected(rowIndex);
			var allRecord = view.getStore().getRange();
			if(checked == true && selected == false){
				var selectedRecordArray = [];
				for(var i=0; i<allRecord.length; i++){			
					var selectedRecord = view.getSelectionModel().isSelected(allRecord[i]);
					if(selectedRecord == true  && (allRecord[i].data.mandatory == true ||allRecord[i].data.mandatory == false )) {
						selectedRecordArray.push(allRecord[i]);
					}
				}
				if(selectedRecordArray.length == 0 || selectedRecordArray.length > 0){
					selectedRecordArray.push(allRecord[rowIndex]);
				}			
				view.getSelectionModel().doMultiSelect(selectedRecordArray);
			}
  		  }
}		
	}],
	plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            edit: function(editor, e, context) {
            	
            }
        }
    }]
});