/**
 * This view is used for Admission Demographics Search Form
 * 
 * @author Pravin.Surve
 */
Ext.define('Academia.view.reports.admission.admissionDemographics.AdmissionDemographicsWithoutBreakup', {
    extend: 'Ext.form.Panel',
    alias: 'widget.admissiondemographicswithoutbreakup',
    title: getAdmissionTranslation('ADMISSION_WITHOUT_BREAKUP'),
    frame: false,
	items:[{
		xtype : 'panel',
		itemId: 'admissiondemographicswithoutbreakupPanel',
		items: [{
	    	xtype: 'fieldcontainer',
	    	layout: 'hbox',
	    	width: 1350,
	        minHeight: 350,
	    	items: [{
	    		xtype: 'panel',
	    		itemId: 'maleFemaleChartPanel',
	    		layout:'vbox',
	    		items: [{
	    			xtype: 'label',
	    			width : 350,
	                text: getAdmissionTranslation('MALE_FEMALE_CHART'),
	    			style: {
	    				color : 'black',
	    				'text-align': 'center',
	    				'font-weight': 'bold',
	    				'font-size': '16px'
	    			}
	    		}, {
	                xtype: 'piechartreport',
	                itemId: 'maleFemaleChart',
	               // width : 350,
	                minWidth : 350,
	                minHeight : 300,
	                store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
	                numericField: 'count',
	                categoryField: 'name'
	            },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
	    	},{
	    		xtype: 'panel',
	    		layout:'vbox',
	    		itemId: 'marriedUnmarriedChartPanel',
	    		items: [{
	    			xtype: 'label',
	    			width : 350,
	    			text: getAdmissionTranslation('MARRIED_UNMARRIED_CHART'),
	    			style: {
	    				color : 'black',
	    				'text-align': 'center',
	    				'font-weight': 'bold',
	    				'font-size': '16px'
	    			}
	    		}, {
	                xtype: 'piechartreport',
	                //width : 350,
	                minWidth : 350,
	                minHeight : 300,
	                itemId: 'marriedUnmarriedChart',
	                store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
	                numericField: 'count',
	                categoryField: 'name'
	            },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
	    	},{
	    		xtype: 'panel',
	    		layout:'vbox',
	    		itemId: 'religionChartPanel',
	    		items: [{
	    			xtype: 'label',
	    			width : 350,
	    			text: getAdmissionTranslation('RELIGION_CHART'),
	    			style: {
	    				color : 'black',
	    				'text-align': 'center',
	    				'font-weight': 'bold',
	    				'font-size': '16px'
	    			}
	    		}, {
	                xtype: 'piechartreport',
	                width : 350,
	                minHeight : 300,
	                itemId: 'religionChart',
	                store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
	                numericField: 'count',
	                categoryField: 'name'
	            },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
	    	}]
	    },{
	    	xtype: 'fieldcontainer',
	    	layout: 'hbox',
	    	width: 1350,
	        minHeight: 350,
	    	items: [{
	    		xtype: 'panel',
	    		layout:'vbox',
	    		itemId: 'countryChartPanel',
	    		items: [{
	    			xtype: 'label',
	    			width : 350,
	                text: getAdmissionTranslation('COUNTRIES_CHART'),
	    			style: {
	    				color : 'black',
	    				'text-align': 'center',
	    				'font-weight': 'bold',
	    				'font-size': '16px'
	    			}
	    		}, {
	                xtype: 'piechartreport',
	                itemId: 'countryChart',
	                width : 350,
	                minHeight : 300,
	                store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
	                numericField: 'count',
	                categoryField: 'name'
	            },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
	    	},{
	    		xtype: 'panel',
	    		layout:'vbox',
	    		itemId: 'categoriesChartPanel',
	    		items: [{
	    			xtype: 'label',
	    			width : 350,
	    			text: getAdmissionTranslation('CATEGORIES_CHART'),
	    			style: {
	    				color : 'black',
	    				'text-align': 'center',
	    				'font-weight': 'bold',
	    				'font-size': '16px'
	    			}
	    		}, {
	                xtype: 'piechartreport',
	                width : 350,
	                minHeight : 300,
	                itemId: 'categoriesChart',
	                store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
	                numericField: 'count',
	                categoryField: 'name'
	            },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
	    	},{
	    		xtype: 'panel',
	    		layout:'vbox',
	    		itemId: 'bloodGroupChartPanel',
	    		items: [{
	    			xtype: 'label',
	    			width : 350,
	    			text: getAdmissionTranslation('BLOOD_GROUP_CHART'),
	    			style: {
	    				color : 'black',
	    				'text-align': 'center',
	    				'font-weight': 'bold',
	    				'font-size': '16px'
	    			}
	    		}, {
	                xtype: 'piechartreport',
	                width : 350,
	                minHeight : 300,
	                itemId: 'bloodGroupChart',
	                store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
	                numericField: 'count',
	                categoryField: 'name'
	            },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
	    	}]
	    },{
	    	xtype: 'fieldcontainer',
	    	layout: 'hbox',
	    	width: 1350,
	        minHeight: 350,
	    	items: [{
	    		xtype: 'panel',
	    		layout:'vbox',
	    		itemId: 'ageRangeChartPanel',
	    		items: [{
	    			xtype: 'label',
	    			width : 350,
	    			text: getAdmissionTranslation('AGE_RANGE_CHART'),
	    			style: {
	    				color : 'black',
	    				'text-align': 'center',
	    				'font-weight': 'bold',
	    				'font-size': '16px'
	    			}
	    		}, {
	                xtype: 'piechartreport',
	                //width : 350,
	                minWidth : 350,
	                minHeight : 300,
	                itemId: 'ageRangeChart',
	                store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
	                numericField: 'count',
	                categoryField: 'name'
	            },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
	    	},{
	    		xtype: 'panel',
	    		layout:'vbox',
	    		itemId: 'incomeRangeChartPanel',
	    		items: [{
	    			xtype: 'label',
	    			width : 350,
	    			text: getAdmissionTranslation('INCOME_RANGE_CHART'),
	    			style: {
	    				color : 'black',
	    				'text-align': 'center',
	    				'font-weight': 'bold',
	    				'font-size': '16px'
	    			}
	    		}, {
	                xtype: 'piechartreport',
	                width : 350,
	                minHeight : 300,
	                itemId: 'incomeRangeChart',
	                store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
	                numericField: 'count',
	                categoryField: 'name'
	            },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
	    	}]
	    }]
	}]

});