/**
 * This panel is used for student dashboard view
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.admission.dashboard.AdmissionDashboardView', {
    extend: 'Ext.form.Panel',
    alias: 'widget.admissiondashboardview',
    autoScroll:true,
	frame:false,
	cls: 'panelNoSpace',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,	
	items : [{
		xtype:'panel',
		items:[{
			xtype: 'organizationunit',
	    	itemId: 'admissionDashboardOrganizationUnit'
		},{
			xtype: 'panel',
			itemId: 'admissionReportView',
			autoScroll: false,
			width: '100%',
			cls: 'panelNoSpace',
			layout: {
				type: 'hbox'
			},
			items: [{
				xtype: 'treepanel',
				itemId:'admissionReportTreePanelItemId',
				title: getFeeAndPaymentCommonTranslation('SELECT_REPORTS'),
				store: 'admission.reports.AdmissionReportTreeStore',
				rootVisible: false,
				cls: 'no-tree-icon',
				flex:.2,
				height: 500,
				frame: true,
				border: false,
				collapsible: true,
				animCollapse: false,
				collapseDirection: 'left',
				titleCollapse: true,
				floatable: false,
				listeners: {
					afterrender: function(panel) {
						panel.getEl().on('click', function() {
							if (panel.collapsed) {
								panel.expand();
							}else {
								panel.collapse();
							}
						});
					}
				}
			},{
				xtype: 'admissionreporttabpanel',
				itemId: 'admissionReportTabStructure',
				style:{marginTop:'8px'}
			}]
		}]
	}]
});