/**
 * This view is used for Admission Rejection Analysis View
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.admission.dashboard.AdmissionRejectionAnalysisView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.admissionrejectionanalysisview',
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
        xtype: 'admissionrejectionanalysissearchform',
        itemId: 'admissionRejectionAnalysisSearchForm'
    }, {
    	xtype: 'form',
    	frame: true,
    	layout:'vbox',
    	items:[{
    		xtype:'fieldcontainer',
			layout:'hbox',
			items:[{
				xtype: 'label',
				width : 655,
				text: getAdmissionTranslation('ADMISSION_REJECTION'),
				style: {
					color : 'black',
					'text-align': 'center',
					'font-weight': 'bold',
					'font-size': '16px'
				}
			},{
				xtype: 'button',
				itemId: 'rejectionExtraBtns',
				hidden:true,
				cls:'CustomToolbarBtnExport',
				iconCls:'export-image-icon',
				style:{marginLeft:'-10px'},
				menu: []
			}]
    	},{
    		xtype: 'barchartreport',
            itemId: 'admissionRejectionAnalysisBarChart',
            minWidth: 700,
            minHeight:250,
            height: 500,
            columnHeight: 30,
            columnColor: 'orange',
            store: 'Academia.store.reports.admission.AdmissionRejectionAnalysisStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getAdmissionTranslation('COUNT_OF_STUDENTS'),
            yAxesCategoryField: 'name',
            yAxesCategoryTitle: getAdmissionTranslation('REJECTION_REASONS')
        }]
    }]
});