    /**
     * @author Amit Gupta
     */
Ext.define('Academia.view.reports.admission.dashboard.AdmissionSummaryApprovedFilter', {   
	extend: 'Ext.form.Panel',
	alias: 'widget.admissionsummaryapprovedfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width:226,
			typeAhead:true,
			forceSelection:true,
			allowBlank: false,
			minChars:3,
			store:Ext.create('Academia.store.common.IntakeYearStore'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
/*			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}*/
		},{
			xtype : 'multiselectcombofield',
			cls:'commonAutoHeightMultiselectField',
			fieldLabel: getCommonTranslation('SEAT_TYPE'),
			name: 'seatType',
			itemId:'seatType',
			displayField: 'value',
			valueField: 'id',
			typeAhead : true,
			forceSelection : true,
			editable: false,
			disableKeyFilter: false,
			store:Ext.create('Academia.store.common.AllSeatTypeListStore'),
			listConfig: {
				listeners: {
				beforeshow: function(picker) {
				picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
			return '<div class="search-item">' +
					'{code}'  + '{value}' +
			        '</div>';
			}
			}
			}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'programGroup',
			itemId:'programGroupItemId',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:'program.ProgramGroupStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true
		}, {
			xtype: 'customcombobox',
			name: 'programCategory',
			itemId:'programCategoryId',
			fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
			store:'program.ProgramCategoryByProgramGroupStore',
			displayField:'value',
			valueField:'id',
			disabled:true,
			forceSelection:true
		}]

	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name:'fromDate',
			itemId:'fromDate',
			vtype : 'daterange',
     	   	endDateField : 'toDate',
			fieldLabel: getEnquiryTranslation('FROM_DATE'),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name:'toDate',
			itemId:'toDate',
			vtype : 'daterange',
      	   	startDateField : 'fromDate',
			fieldLabel: getEnquiryTranslation('TO_DATE'),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]

	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			formBind:true,
			// buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});