/*
 * @author Pragati laad 
 */
Ext.define('Academia.view.reports.admission.dashboard.DtefAdmissionFilter', {   
	extend: 'Ext.form.Panel',
	alias: 'widget.dtefadmissionfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		itemId: 'applicationdteffilterprogrmbatchseattypecontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'programGroup',
			itemId:'programGroupItemId',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:Ext.create('Academia.store.program.ProgramGroupStoreForLocalSerach'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			queryMode: 'remote',
			minChars:3,
			queryParam:'programGrpName',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation('SEARCHING'),
 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					'{value}' +
 					'</div>';
 				}
 			}
		},{
			xtype: 'customcombobox',
			name: 'program',
			itemId:'programId',
			 fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store: 'common.ProgramsByAcademyIdLocationId',
			valueField : 'id',
			displayField:'valueCode',
			valueField:'id',
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+
	                    '</div>';
	                }
	            }
		}, {
			xtype: 'customcombobox',
			name: 'batch',
			itemId:'batchId',
			fieldLabel: getPersonModuleTranslation('BATCH'),
			store: 'common.BatchesByProgramId',
			valueField : 'id',
			displayField : 'value',
			disabled:true,
			editable: false,
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+
	                    '</div>';
	                }
	            }
		}]

	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
            xtype: 'customcombobox',
            name: 'responseStatus',
            fieldLabel: getCommonTranslation('RESPONSE_STATUS'),
            displayField: 'value',
            valueField: 'name',
            allowBlank: true,
            store: Ext.create('Academia.store.common.ResponseStatusStore'),
        },{
			xtype: 'customcombobox',
			name: 'response',
			itemId:'responseId',
			fieldLabel : getCommonTranslation('RESPONSE'),
			store: Ext.create('Academia.store.common.ResponseStore'),
			valueField : 'value',
			displayField:'value',
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'+
	                    '</div>';
	                }
	            }
		},{
        	xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('APPLICATION_STATUS'), 
			name: 'applicationstatus',
			itemId: 'applicationStatus',
			editable: false,
			store: Ext.create('Academia.store.common.ApplicationStatusStore'),                 
			valueField: 'name',
			displayField: 'value'
        }]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name:'fromDate',
			itemId:'fromDate',
			vtype : 'daterange',
			endDateField: 'toDate',
			maxValue: new Date(),
			fieldLabel: getEnquiryTranslation('FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name:'toDate',
			itemId:'toDate',
			vtype : 'daterange',
			allowBlank : true,
			startDateField: 'fromdate',
			maxValue: new Date(),
			fieldLabel: getCommonTranslation('TILL_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},
		{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			forceSelection: true,
            editable: true,
            typeAhead:false,
            cls:'commonAutoHeightMultiselectField',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            minChars:3,
            anyMatch:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearByBatchStore');
					combo.bindStore(store)
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[
			{
			xtype : 'customcombobox',
			fieldLabel : getPersonModuleTranslation('NATIONAL_ID'),
			name : 'nationalId',
			itemId : 'nationalId',
			displayField:'value',
			valueField:'value',
			forceSelection: true,
            editable: true,
            typeAhead:true,
            queryParam:'query',
            cls:'commonAutoHeightMultiselectField',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            minChars:3,
            anyMatch:true,
			 width:226,
			 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			 enableKeyEvents  : 'true',
			 hideTrigger:false,
			 triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.FindAllNationalIdsStore');
					combo.bindStore(store)
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchButtonId',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetButtonId',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});