/*
 * @author Pragati Laad
 */
Ext.define('Academia.view.reports.admission.dashboard.DtefAdmissionGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.dtefadmissiongrid',
	store : 'reports.admission.AdmissionDtefDashboardGridStore',
	cls:'enqgridsummarycls',
	border: true,
	frame:false,
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	isGridConfigurable:  true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'reports.admission.AdmissionDtefDashboardGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);    
		this.setTitle(getCommonTranslation('DTEF_ADMISSION_LIST')); 
	},
	tbar : [{
		xtype : 'button',
		itemId : 'sendToDTEFBtn',
		tooltip : getCommonTranslation('SEND_TO_DTEF'),
		text : getCommonTranslation('SEND_TO_DTEF'),
		disabled:true,

	},'->',
	],
	columns: [{
		header:  getCommonTranslation('APPLICATION_ID'),
		dataIndex: 'applicantCode',
		flex:.1
	},{
		header:  getAdmissionTranslation('NAME'),
		dataIndex: 'applicantName',
		flex:.1
	},{
		header:  getAdmissionTranslation('ACADEMY'),
		dataIndex: 'academyName',
		flex:.1
	},{
		header:   getEnquiryTranslation('LOCATION'),
		dataIndex: 'locationName',
		flex:.1
	},{
		header:  getAdmissionTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1
	},{
		header:  getAdmissionTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1
	},{
		header:  getAdmissionTranslation('SEAT_TYPE'),
		dataIndex: 'seatType',
		flex:.1
	},{
		header:  getAdmissionTranslation('APPLICATION_STATUS'),
		dataIndex: 'applicationStatus',
		flex:.1,
		renderer:function(value, meta, record){
            if(!isNullOrEmpty(value)) {
                if(value=="ADMISSION_GRANTED")
                    {
                		return getAdmissionTranslation('ADMISSION_GRANTED');
                    }
                else if(value =="APPROVED")
                	{
                	  return getAdmissionTranslation('APPROVED');
                	}
                else if(value =="REJECTED")
            	{
            	  return getAdmissionTranslation('REJECTED');
            	}
                else if(value =="INCOMPLETE")
            	{
            	  return getAdmissionTranslation('INCOMPLETE');
            	}
                else if(value =="WITHDRAWN")
            	{
            	  return getAdmissionTranslation('WITHDRAWN');
            	}
                else if(value =="DIRECT_ADMISSION")
            	{
            	  return getAdmissionTranslation('DIRECT_ADMISSION');
            	}
                else{
                	 return getAdmissionTranslation('MID_TERM_ADMISSION');
                }
            }       
        }
	},{
		header:  getCommonTranslation('RESPONSE_STATUS'),
		dataIndex: 'responseStatus',
		flex:.1
	},{
		header:  getCommonTranslation('RESPONSE'),
		dataIndex: 'response',
		flex:.1
	},{
		header:  getCommonTranslation('RESPONSE_DATE'),
		dataIndex: 'responseDate',
		flex:.1,
		renderer:function(date) {
            if(!isNullOrEmpty(date)){
             return dateRender(date);
            }else{
                return null;            
            }
            }
	}]
});