Ext.define('Academia.view.reports.allReports.ReportsCardTpl', {
	extend: 'Ext.view.View',
    alias: 'widget.reportscardtpl',
    cls: 'reportMenuDataViewCls',
    itemSelector: 'div.report-menu-item',
    overItemCls: 'report-menu-item-hover',
    selectedItemCls: 'report-menu-item-selected',
    initComponent: function () {
        var me = this;
        me.store = Ext.create('Ext.data.Store', {
        	 fields: ['featureName', 'privilegeCode'],
        	 data: [],
            autoLoad: false
        });

        me.callParent(arguments);
    },
    tpl: new Ext.XTemplate(
        '<div class="menu-wrapper">',
        '   <tpl for=".">',
        '       <div class="report-menu-item">',
        '           <div class="menu-title-row">',
        '               <div class="menu-title"> <span class="menu-title-span-cls">{[ getCommonTranslation(values.privilegeCode) ]}</span>',
        				'<span style="display:inline-block; width:20px;margin-top:0px;margin-left:20px"><img class="hoverImage reportsBoxInnerIconsCls" src="{[ this.getIcon(values.privilegeCode) ]}" style="width:80%; height:80%; object-fit:cover;transform: translate(4px, 4px);"></span></div>',
        '               <div class="menu-icon clock-icon"></div>',
        '           </div>',
        '           <div class="menu-subtitle">{[ this.getReportDescription(values.privilegeCode) ]}</div>',
        '       </div>',
        '   </tpl>',
        '</div>',
        {
            getIcon: function(privilegeCode) {
            //	var analyticsReportsArray = ["EMPLOYEE_DETAIL_REPORT", "A002", "A003"];
            	var analyticsReportsArray = ["HOSTEL_OCCUPANCY_REPORT","HOSTEL_REPORT_RESIDENCE_REPORT","WAITING_LIST","STUDENT_WAITING_LIST","RESIDENCE_SELECTION_CHOICES_SELECTED","APPLICANT_WAITING_LIST","BULK_RESIDENCE_APPLICATION_STATUS","SES_SCORE","HOSTEL_AVAILABLE_REPORT","RESIDENCE_AUDIT_REPORT","STUDENT_RESIDENCE_REPORT","STUDENT_RESIDENCE_HISTORY_REPORT","PLACEMENT_SUMMARY","DROOL_MASTER_REPORT","BLACKBOARD_REPORT","ELECTION_RESULT_REPORT","EVOLVE_MASTERY_DASHBOARD","USER_LIST_REPORT","PERSON_INFORMATION_REPORT","USER_LOGIN_DASHBOARD","USER_LOGIN_DETAILS","USER_LINK_HITS_DETAILS","EMPLOYEE_ATTENDANCE_REPORT","EMPLOYEE_ATTENDANCE_SUMMARY","SCHOOL_WISE_CURRENT_DATE_ATTENDANCE_REPORT","ACTIVE_TEACHER_REPORT","EMPLOYEE_DETAIL_REPORT"];

                if (Ext.Array.contains(analyticsReportsArray, privilegeCode)) {
                    return "resources/images/Graphical_icon.svg";   // your icon CSS class
                }
                return "resources/images/Tabular_icon.svg";
            },
            getReportDescription: function(privilegeCode) {
            	return getCommonTranslation(privilegeCode+"_DESCRIPTION");
            }
        }
    )
});