/**
 * This is used for column chart report
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.common.ColumnChartReport', {
    extend: 'Ext.chart.Chart',
    alias: 'widget.columnchartreport',
   /* requires : ['Ext.chart.axis.OverlapLabelOptions' ], */ //added for get rid of not showing bigger length labels 
    animate: true,
    shadow: true,
    initComponent: function() {
        var this$ = this;
        var numberField = !isNullOrEmpty(this.xAxesNumericField)?this.xAxesNumericField:'number';
        var categoryField = !isNullOrEmpty(this.yAxesCategoryField)?this.yAxesCategoryField:'category';
        var numericTitle = !isNullOrEmpty(this.xAxesNumericTitle)?this.xAxesNumericTitle: getCommonTranslation('NUMERIC_TITLE');
        var categoryTitle = !isNullOrEmpty(this.yAxesCategoryTitle)?this.yAxesCategoryTitle:getCommonTranslation('CATEGOTY_TITLE');
        var columnWidth = !isNullOrEmpty(this.columnWidth)?this.columnWidth: REPORT_CONSTANTS.COMMON_COLUMN_WIDTH;
        var columnColor = !isNullOrEmpty(this.columnColor)?this.columnColor: REPORT_CONSTANTS.COMMON_COLOR;
        var chartStore = null;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store);
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['number', 'category'],
        		data: [{
        			number :0,
        			category : 'Category'
        		}]
        	});
        }
        Ext.apply(this$, {
        	store: chartStore,
            axes: [{
                type: 'Numeric',
                position: 'left',
                fields: [numberField],
                label: {
                    renderer: Ext.util.Format.numberRenderer('0,0')
                },
                title: numericTitle,
                grid: true,
                minimum: 0
               // decimals: 0,
               // majorTickSteps: 0
            }, {
                type: 'Category',
                position: 'bottom',
                fields: [categoryField],
                title: categoryTitle,
                //below options added for get rid of not showing bigger length labels 
                //labelRows: 2,
                //hideOverlappingLabels: false,
                label   : {
                	rotate:{degrees:45}
                }
            }],
            series: [{
                type: 'column',
                axis: 'left',
                xField: categoryField,
                yField: numberField,
                gutter : 40,
                highlight: true,
                tips: {
                  trackMouse: true,
                  height: 28,
                  layout: 'fit',
                  renderer: function(storeItem, item) {
                	  var tipTitle = storeItem.get(categoryField) + ': ' + storeItem.get(numberField);
                	  var length = (tipTitle.length)* 10;
                	  this.setWidth(length);
                	  this.setTitle(tipTitle);
                  }
                },
                renderer: function(sprite, storeItem, barAttr, i, store) {
                	barAttr.fill = columnColor;
                	barAttr.width = columnWidth;
              	  	return barAttr;
                },
                /*label: {
                	display: 'insideEnd',
                	'text-anchor': 'right',
                    field: numberField,
                    renderer: Ext.util.Format.numberRenderer('0'),
                    orientation: 'horizontal',
                    color: '#333'
                },*/
                style: {
                    'stroke-width': 0,
                    'stroke': '#fff'
                },
                renderer: function(sprite, record, attr, index, store) {
//                	var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A","#FFFF99","#FF9999","#FFFFB2","#99CC99","#D6ADC2","#C2EBFF","#99C2EB"][index];
                	var baseController = Academia.app.getController('Academia.controller.base.BaseController');
                	var color = baseController.getRandomColor(index);
                    /*return Ext.apply(attr, {
                        fill: color
                    });*/
                    
                    if(store.getCount() <= 5){
                		return Ext.apply(attr, {
                            fill: color,
                            width: 30,
                            x: Math.max(attr.x, attr.x + (attr.width - 30) / 2)
                        });
                	}
                	else{
	                    return Ext.apply(attr, {
	                        fill: color
	                    });
                	} 
                },
                listeners: this$.seriesListeners
            }],
            listeners: {
                /*refresh: function(chart) {
                	var count = chart.getStore().getCount();
                	if(count>0){
                		var gutter = 40;
                		var chartWidth = (count * columnWidth)+ (count * gutter) + 50; 
                		chart.setWidth(chartWidth);
                		chart.doComponentLayout();
                	}
                }*/
            }
        });

        this$.callParent(arguments);
    }
});