/**
 * This view is used for unassigned complaint 
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.complaints.UnassignedComplaintReportView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.unassignedcomplaintreportview',
    frame: true,
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
        xtype: 'form',
        itemId: 'unassignedComplaintSearchForm',
        frame: true,
        plugins: "formlabelrequired",
        items:[{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'customcombobox',
                name: 'complaintTypeId',
                itemId: 'complaintTypeField',
                fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
                displayField: 'value',
                valueField: 'id',
                autoload: false,
                editable: false,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintTypes');
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchButtonId',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'resetButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }, {
    	xtype: 'unassignedcomplaintgrid',
    	itemId: 'unassignedComplaintReportGrid'
    }]
});