/**
 * This view is used for faculty closure reason 
 * @author Pravin.Surve
 */

Ext.define('Academia.view.reports.faculty.FacultyServiceLevelView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.facultyservicelevelview',
    title: getServiceRequestTranslation('SERVICE_LEVEL_GRAPH'),
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
    	xtype: 'facultydashboardcommonsearchform',
        itemId: 'facultyServiceLevelSearch'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'groupedbarchart',
            itemId: 'facultyServiceLevelChart',
            width: 700,
            minHeight: 500,
            maxHeight: 1000,
            store: 'Academia.store.reports.servicerequest.ServiceLevelGraphStore',
            xAxesCategoryField: 'MONTH',
            xAxesCategoryTitle: getServiceRequestTranslation('MONTHS'),
            yAxesNumericField: 'count',
            yAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
            groupField: ['Beyond Limit', 'Beyond', 'Before', 'OnDate']
        }]
    }]
});