/**
 *  This grid is used for detail student/faculty request
 *  @author mahendr.Vishvkarma
 */
Ext.define('Academia.view.reports.servicerequest.serviceDetailReportResultGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias: 'widget.serviceDetailReportResultGrid',
	title: getServiceRequestTranslation('SERVICE_DETAIL_REPORT'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	columns: [{
		header: getServiceRequestTranslation('REQUEST_ID'),
		dataIndex: 'requestId',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return '<a href="#">'+ value +'</a>';
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_CATEGORY'),
		dataIndex: 'requestCategory',
		sortable: true,
		flex: .2,
		renderer: function(value){
			if(value!=null){
				return	getServiceRequestTranslation(value);
			}
			else
				return value;
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_TYPE'),
		dataIndex: 'type',
		sortable: true,
		flex: .2
	}, {
		header: getServiceRequestTranslation('REQUESTER_NAME'),
		dataIndex: 'requesterName',
		sortable: true,
		flex: .2
	}, {
		header: getServiceRequestTranslation('REQUEST_DATE'),
		dataIndex: 'requestDate',
		sortable: true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		} 
	},{
		header: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
		dataIndex: 'assigneeName',
		sortable: true,
		flex: .2
	},{
		header: getServiceRequestTranslation('SERVICE_REQUEST_STATUS'),
		dataIndex: 'requestStatus',
		sortable: true,
		flex: .2
	},{
		header: getServiceRequestTranslation('SERVICE_REQUEST_DESCRIPTION'),
		dataIndex: 'reasons',
		sortable: true,
		flex: .2
	},{
		header: getServiceRequestTranslation('PROGRAM'),
		dataIndex: 'programName',
		sortable: true,
		flex: .2
	},{
		header: getServiceRequestTranslation('BATCH'),
		dataIndex: 'batchName',
		sortable: true,
		flex: .2
	},{
		header: getServiceRequestTranslation('STUDENT_ID'),
		dataIndex: 'requesterCode',
		sortable: true,
		flex: .2
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.reports.servicerequest.ServiceDetailReportStore');
	}
});