/**
 * This view is used for the Follow Up Scheduled report quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.student.FollowUpScheduledReportQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.followupscheduledreportquicksearchform',
    frame: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'requestsubrequesttypefieldcontainer',
        itemId: 'requestTypeFieldContainer',
        layout: 'hbox'
    }, {
        xtype: 'fieldcontainer',
        itemId: 'progrmBatchSectionContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programComboField',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            
            displayField: 'valueCode',
            valueField: 'id',
           // queryMode: 'local',
            queryParam:'qry',
            //  autoload: false,
              allowBlank: true,
  			minChars:3,
  			typeAhead:false,
              emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
              forceSelection:true,
            
             listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            },
            listConfig: {
                listeners: {
                beforeshow: function(picker) {
                  picker.minWidth = picker.up('combobox').getSize().width;
                  }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                  return '<div class="search-item">' +
                  '{code} / {value}'+
                  '</div>';
                  }
                }
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchComboField',
            fieldLabel: getCommonTranslation('BATCH'),
            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'sectionId',
            itemId: 'sectionComboField',
            fieldLabel: getCommonTranslation('SECTION'),
            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            width: 226,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMultiSelect');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
        	labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'livesearchcombo',
            itemId: 'assigneeCombo',
            store: 'Academia.store.reports.servicerequest.SystemUsersByAcademyLocationIds',
            hidden: true,
            fieldLabel: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
            name: 'assignTo'
        }/*, {
            xtype: 'nestedJsonCombo',
            itemId: 'assigneeCombo',
            store: Ext.create('Academia.store.reports.servicerequest.SystemUsersByAcademyLocationIds'),
            displayField: 'value', 
        	valueField: 'id',
            fieldLabel: getServiceRequestTranslation('ASSIGN_TO'),
            name: 'assignTo', 
        	typeAhead: true,
        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        	queryParam : 'term',
        	enableKeyEvents  : 'true',
        	minChars: 3, 
        	remoteFilter: true,
        	displayTpl: new Ext.XTemplate(
        			'<tpl for="."between=" ">',
        			'{[typeof values === "string" ? values : values["firstName"]]} ' +
        			'{[typeof values === "string" ? values : values["lastName"]]}  ' +
        			'</tpl>'
        	),

        	listConfig :{
        		loadingText: 'Searching...',
        		emptyText: 'No matching posts found.'
        	}
        }*/, {
            xtype: 'datefield',
            itemId: 'startDate',
            fieldLabel: getServiceRequestTranslation('FOLLOW_UP_START_DATE'),
            name: 'startDate',
            vtype: 'daterange',
            endDateField: 'endDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            
            editable: false
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId : 'endDate',
            fieldLabel: getServiceRequestTranslation('FOLLOW_UP_END_DATE'),
            vtype: 'daterange',
            startDateField: 'startDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SELECT_NAME'),
            
            store: 'common.SelectNameComboStore',
            editable: false,
            queryMode: 'local',
            name: 'selectedNameField',
            itemId: 'selectedNameField',
            valueField: 'id',
            displayField: 'value',
            value: 'FIRST_NAME'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
            
            itemId: 'selectedName',
            name: 'firstName'
        }]
    }, {
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]

});