/**
 * This view is used for the online user report quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.systemutilization.onlineusers.OnlineUserReportQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.onlineuserreportquicksearchform',
    autoScroll: true,
    frame: false,
    cls:'customSearchPanel',
    items:[{
    	xtype:'systemusagecommonsearchdailyusageform',
    	itemId:'onlinesystemusagecommonsearchform'
    },{
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		collapsible:true,
		collapsed:true,
		width:'100%',
		style: {
         	 marginTop: '40px!important',
         	 marginLeft:'20px!important'
        },
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
           /*style : {
//        		marginTop : '20px',
        		marginLeft : '00px'
        	},*/
            
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'fieldcontainer',
                fieldLabel : getCommonTranslation('USER_TYPE'),
                itemId: 'radioPanelAverage',
                labelAlign: 'top',
                width: 'auto',
//                width: 226,
                /*defaults: {
                    width: 226,
                    labelAlign: 'top'
                },*/
                /*style : {
            		marginLeft : '10px'
            	},*/
                layout: {
                    type: 'hbox'
                },
                items: [/*{
                    xtype: 'radiofield',
                    boxLabel: getCommonTranslation('ALL'),
                    name: 'userRadio',
                    itemId: 'allRadioBtn',
                    inputValue: 'all'
                }, */{
                    xtype: 'radiofield',
                    boxLabel: getCommonTranslation('INDIVISUAL'), //Alpha numeric
                    name: 'userRadio',
                    inputValue: 'individual',
                   // width:113,
                    itemId: 'individualRadioBtn'
                }, {
                    xtype: 'radiofield',
                    boxLabel: getCommonTranslation('USER_GROUPS'), //Alpha numeric
                    name: 'userRadio',
                    //width:113,
                    inputValue: 'userGroups',
                    itemId: 'userGroupRadioBtn'
                }]
            },{
                xtype: 'customcombobox',
                name: 'USER_BELONGS_TO',
//                width: 226,
                fieldLabel: getCommonTranslation('USER_BELONGS_TO'),
                store: 'securitysetup.unlockUser.userBelongsToStore',
                valueField: 'id',
                displayField: 'value',
                triggerAction: 'all',
                forceSelection: true,
                editable: false,
                labelAlign: 'top'
            }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'userTypeIndividualFieldContainer',
        layout: 'hbox',
        style : {
    		marginLeft : '10px'
    	},
        disabled: true,
        hidden: true,
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'multiselectcombofield',
//          xtype:'customcombobox',
            name: 'USER_IDS',
            itemId:'ol_user_id',
            store:'criteriabuilder.userquicksearch.QuickSearchCode',
            fieldLabel: getCommonTranslation('USER_NAME'),
            width: 460,
            valueField: 'id',
            displayField: 'value',
            queryParam:'code',
            queryMode: 'local',
            minChars:3,
            typeAhead:true,
            triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            forceSelection:true,
//            hidden:true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
            	loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{code} / {value}'  +
                    '</div>';
                },
                listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		}
        }
        }/*{
            xtype: 'multiselectcombofield',
            name: 'USER_ID',
            fieldLabel: getCommonTranslation('USER_ID'),
            store: 'systemusage.UserNames',
            displayField: 'code',
            valueField: 'code',
            editable: true,
    		typeAhead: true,
            inputHeight: '30px',
//            height: '30px',
            queryMode: 'local',
            itemId: 'ol_user_id'
        }, {
            xtype: 'multiselectcombofield',
            name: 'USER_NAME',
            fieldLabel: getCommonTranslation('USER_NAME'),
            store: 'systemusage.UsersNameStore',
            displayField: 'value',
            valueField: 'id',
            inputHeight: '30px',
//            height: '30px',
            editable: true,
            queryMode: 'local',
    		typeAhead: true,
            itemId: 'ol_user_name'
        }*/]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'userGroupFieldContainer',
        layout: 'hbox',
        disabled: true,
        hidden: true,
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style : {
    		marginLeft : '10px'
    	},
        items: [{
            xtype: 'multiselectcombofield',
            name: 'USER_GROUP',
            fieldLabel: getCommonTranslation('USER_GROUP'),
            labelAlign: 'top',
            store: 'systemusage.UserGroupStore',
            displayField: 'userGroupName',
            valueField: 'id',
//            height: '30px',
            inputHeight: '30px',
            editable: false,
            queryMode: 'local',
            itemId: 'frequency_user_group'
        }]
    }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style : {
    		marginLeft : '9px',
    		marginTop : '14px'
    	},
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'onlineUserReportListSearchButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'resetBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
   
});