/**
 * @author Suraj Chouhan
 */
var documentStatus =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"VERIFIED", "name":"Verified"},
        {"value":"RE_SUBMIT", "name":"Re-Submit"}]
});
Ext.define('Academia.view.scholarship.managescholarship.ManageScholarshipEditDocument',{
	extend: 'Ext.window.Window',
	alias: 'widget.managescholarshipeditdocument',
	title: getCommonTranslation('DOCUMENTS_DETAILS'),
	frame: true,
	modal:true,
	height:400,
	plugins: "formlabelrequired",
	width:560,
	items : [{
		xtype: 'form',
		defaults: {
			labelAlign: 'top',
			width:226,
		},
		items: [{
		        xtype: 'hidden',
		        itemId: 'form_id',
		        name: 'id'
		    },{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'doucumentMasterName',
				itemId:'doucumentMasterName',
				allowBlank:false,
				disabled:true,
				fieldLabel: getCommonTranslation('DOCUMENT_NAME'),
			},{
				xtype: 'textfield',
				name: 'documentApplicability',
				itemId:'documentApplicability',
				allowBlank:false,
				disabled:true,
				fieldLabel: getCommonTranslation('DOCUMENT_TYPE'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'inspectionDate',
				itemId:'inspectionDate',
				allowBlank:false,
				disabled:true,
				fieldLabel: getCommonTranslation('INSPECTION_DATE'),
			},{
				xtype: 'textfield',
				name: 'inspectionBy',
				itemId:'inspectionBy',
				allowBlank:false,
				disabled:true,
				fieldLabel: getCommonTranslation('INSPECTION_BY'),
				listeners: {
	    			render: function(field) {
	    				return dateFormatRender(field);
	    			}
	    		},
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'documentStatus',
				itemId:'documentStatus',
				allowBlank:false,
				store: documentStatus,
	        	valueField: 'value',
	        	displayField: 'name', 
	        	editable: false,
	        	querymode: 'local',
				fieldLabel: getCommonTranslation('DOCUMENT_STATUS'),
				typeAhead:false,
				forceSelection:true
			}]
		},{

			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textarea',
				name: 'remark',
				itemId:'remark',
				width: 466,
				maxLength:255,
				fieldLabel: getCommonTranslation('REAMRK'),
			}]
		
		},{
				xtype:'fieldcontainer',
				items: [{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					ui: 'CustomBtnSubmit',
					itemId: 'saveBtn',
					formBind : true,
					scale: CONSTANTS.BUTTONSIZE
				}, {

					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtn',
					scale: CONSTANTS.BUTTONSIZE
				
				}]
			}]
	}]
});