/**
 * 
 * @author priyanshi sharma
 */
Ext.define('Academia.view.scholarship.scholarshiplisting.ListOfOnlineDocumentsGrid', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.listofonlinedocumentsgrid',
    store : 'scholarships.SPScholarshipListDocumentsGridStore',
    title: getCommonTranslation('LIST_OF_ONLINE_DOCUMENTS_PORTAL'),
    border: true,
    isGridConfigurable: true,
	enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	tbar: [{
		xtype: 'button',
		itemId: 'uploadBtn',
		text: getCommonTranslation("UPLOAD"),
		hidden:true
	}], 
	columns: [{
		header:  getCommonTranslation("DOCUMENT_NAME"),
		dataIndex:'doucumentMasterName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation("DOCUMENT_TYPE"),
		dataIndex:'documentApplicability',
		flex:1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)) {
				switch(value) {
				  case 'MANDATORY':
					  return 'Mandatory';
				    break;
				  case 'OPTIONAL':
					  return 'Optional';
					  break;
				  default:
					  break;
				}
			} 
			return value;
		}
	},{
		header:  getCommonTranslation("SUBMISSION_DATE"),
		dataIndex: 'submissionDate',
		flex:1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	},{
		header:  getCommonTranslation("SUBMISSION_MODE"),
		dataIndex: 'submissionMode',
		flex:1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation("DOWNLOAD_ATTACHMENT"),
		dataIndex: 'downloadFileName',
		flex:1,
		sortable:true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}
		}
	},{
		header:  getCommonTranslation("UPLOADED_DOCUMENT"),
		dataIndex: 'uploadFileName',
		flex:1,
		sortable:true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}
		}
	},{
		header:  getCommonTranslation("DOCUMENT_STATUS"),
		dataIndex: 'documentStatus',
		flex:1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(isNullOrEmpty(value)){
				var grid = Ext.ComponentQuery.query('spscholarshiplistgrid');
				var selectedRecord = grid[0].getSelectionModel().getSelection()[0].data;
				if(selectedRecord.scholarShipRequstStatusNomination == 'DOCUMENT_RE_SUBMISSION'){
					return '<span style="color:red">-</span>';
				}else{
					return '<span style="color:red">'+getCommonTranslation('PENDING')+'</span>';
				}
			}else if(value=='SUBMITTED'){
				return '<span style="color:green">'+getCommonTranslation('SUBMITTED')+'</span>';
			}else if(value=='VERIFIED'){
				return '<span style="color:green">'+getCommonTranslation('VERIFIED')+'</span>';
			}else if(value=='RE_SUBMIT'){
				return '<span style="color:red">'+getCommonTranslation('RESUBMIT')+'</span>';
			}
		}
	},{
		header:  getCommonTranslation("INSPECTION_DATE"),
		dataIndex: 'inspectionDate',
		flex:1,
		sortable:true,
		hidden:true,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	},{
		header:  getCommonTranslation("REAMRK"),
		dataIndex: 'remark',
		flex:1,
		hidden:true,
		sortable:true
	},{
    	//header: getCommonTranslation('PREVIEW'),
    	dataIndex: 'remark',
    	flex : 1,
    	itemId:'uplodaDoc',
    	renderer: function(value, meta, record) {
        	if(record.data.isAllowUplaod){
        		return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 8px 10px;" >'+getCommonTranslation("UPLOAD")+'</a>';
        	}
        	else{
        		return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 8px 10px;opacity: 0.5;cursor: default;" >'+getCommonTranslation("UPLOAD")+'</a>';
        	       
        	}
    	}
    }]
});