/**
 * @author pritam.patil
 * This is used for Scholarship listing screen search form
 */
Ext.define('Academia.view.scholarship.scholarshiplisting.ScholarshipListingSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.scholarshiplistingsearchform',
    autoScroll: true,
    frame: false,
    layout: 'vbox',
    cls: 'customSearchPanel',
    plugins : "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'scholarshipList',
        //   method : 'POST',
        items: [{
            xtype: 'multiselectcombofield',
            name: 'scholarshipAcademyLocationId',
            itemId: 'scholarshipAcademyLocationId',
            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
            valueField: 'id',
		    displayField: 'value',
			store: Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
			width : 464,
			labelAlign : 'top',
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			/*	getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}*/
			}
		},{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 232,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('APPLICABLE_FOR'),
                name: 'requesterType',
                itemId: 'requesterType',
                editable: false,
                store: Ext.create('Ext.data.Store', {
                    fields: ['name', 'value'],
                    data : [{
	                    	name:"Student", value:"Student"
	                    	},{
	                    	name:"Applicant", value:"Applicant"
	                    }]
                }),
                valueField: 'value',
                displayField: 'name',
                queryMode: 'local',
                selectOnFocus: true,
                value: 'Student',
                forceSelection: false
            },{
	        	xtype: 'multiselectcombofield',
	        	fieldLabel: getCommonTranslation('ACCOUNTING_YEAR'),
	        	name: 'accountingYear',
	        	itemId: 'accountingYear',
	        	store: Ext.create('Academia.store.scholarships.ScholarshipAcountingYearStore'),
	        	valueField: 'id',
	        	displayField: 'currentAccountingYear',
	        	queryParam:'qry',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
					        });
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				/*	getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}*/
				}
	        }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('SCHOLARSHIP_ID_NAME'),
                itemId: 'scholarshipId',
                name: 'scholarshipId',
                store:'feeandpayment.managebill.ScholarshipByAwardeeAccountingYearStore',
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'qry',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			forceSelection:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{studentCode} / {studentName}' +
    					'</div>';
    				}
    			}
            },{
            	xtype: 'customcombobox',
	            itemId:'scholarshipCategoryId',
	            name:'scholarshipCategoryId',
	            editable: false,
	            displayField: 'value',
	            valueField: 'id',
	            queryMode: 'local',
	            fieldLabel: getCommonTranslation('SCHOLARSHIP_CATEGORY'),
	            store:Ext.create('Academia.store.scholarships.ScholarshipAwardeeCategory'),
	            forceSelection:true,
	            allowBlank: false,
	            value:getCommonTranslation('ALL')
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 232,
                labelAlign: 'top'
            },
            items: [{
            	xtype: 'customcombobox',
            	fieldLabel: getCommonTranslation('STUDENT_STATUS'),
            	name: 'stdStatus',
            	itemId: 'stdStatus',
            	editable: false,
            	allowBlank:false,
            	store: Ext.create('Ext.data.Store', {
            		fields: ['name', 'value'],
            		data : [{
            			name:getCommonTranslation('SCHL_ACTIVE'), value:"ACTIVE"
            		},{
            			name:getCommonTranslation('SCHL_INACTIVE'), value:"INACTIVE"
            		},{
            			name:getCommonTranslation('SCHL_ALL'),value:'ALL'
            		}]
            	}),
            	valueField: 'value',
            	displayField: 'name',
            	queryMode: 'local',
            	value: 'ACTIVE',
            	forceSelection: false
            },{
              	xtype: 'customcombobox',
    			name: 'studentId',
    			itemId:'studentId',
    			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
    			store: Ext.create('Academia.store.feeandpayment.managebill.ScholarshipAwardeeListStore'),
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'studentNameOrCode',
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			queryCaching: false,
    			forceSelection:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{studentCode} / {studentName}' +
    					'</div>';
    				}
    			}
            }, {
              itemId: 'applicantId',
            	xtype: 'customcombobox',
    			name: 'applicantId',
    			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
    			store: 'feeandpayment.managebill.Applicant',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				hidden:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{studentCode} / {studentName}' +
    					'</div>';
    				}
    			}
            },  {
                xtype: 'multiselectcombofield',
                fieldLabel: getCommonTranslation('PROGRAM_ID_NAME'),
                name: 'programId',
                itemId: 'programId',
                editable: false,
                store: 'scholarships.ScholarshipProgramStore',
                displayField: 'valueCode',
                valueField: 'id',
                queryMode: 'local'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 232,
                labelAlign: 'top'
            },
            items: [{
           	 xtype: 'customcombobox',
             fieldLabel: getCommonTranslation('AMOUNT_TYPE'),
             name: "AMOUNT_TYPE",
             itemId: "scholList_amountType",
             editable: false,
             store: 'scholarships.AmountTypes',
             valueField: 'id',
             displayField: 'value',
             value: getCommonTranslation('ALL'),
             queryMode: 'local'
        },{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('DISBURSMENT_MODE'),
                name: "DISBURSEMENT_MODE",
                itemId: "scholList_disbursmentMode",
                editable: false,
                store: 'scholarships.DisbursmentModes',
                valueField: 'id',
                displayField: 'value',
                queryMode: 'local',
                selectOnFocus: true,
                value: getCommonTranslation('ALL'),
                forceSelection: false
            },  {
            	xtype: 'customcombobox',
    			name: 'scholarshipStatus',
    			fieldLabel:getCommonTranslation('SCHOLARSHIP_STATUS'),
    			itemId: 'scholarshipStatus',
    			 store: Ext.create('Ext.data.Store', {
                     fields: ['name', 'value'],
                     data : [{
 	                    	name:"Award Activation Pending", value:"Award Activation Pending"
 	                    	},{
 	                    	name:"Awarded", value:"Awarded"
 	                    },{
 	                    	name:"Rejected", value:"Rejected"
 	                    }]
                 }),
                 valueField: 'value',
                 displayField: 'name',
                 value:'Award Activation Pending'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',

            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'ScholarshipListSearchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation('CLEAR_SEARCH'),
                itemId: 'ClearSearchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});