/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show disbursement pending details in Dialog box.
 * 
 */	   
Ext.define('Academia.view.scholarship.scholarshiplisting.ViewAwardeesDisbursementWindow',
		{
			extend : 'Ext.window.Window',
			alias : 'widget.viewawardeesdisbursementwindow',			
			modal : true,
			autoScroll:true,
			resizable:false,
			height:(Ext.isIE8)?600:'70%',
			width:(Ext.isIE8)?500:'50%',
			title : getCommonTranslation('DISBURSEMENT_DETAILS'), //Disbursement Details
			items : [{
		        xtype: 'form',
		        itemId:'disbursementDetailsForm',
		        items: [{
		        		xtype: 'displayfield',
		        		itemId: 'noOfDisbursement',
		        		labelWidth :'auto',
				        fieldLabel: getCommonTranslation('TOTAL_NO_DISBURSEMENT'), //Total no. of disbursements
				        name: 'noOfDisbursement',
				        value: '0'
				    },{
		        		xtype: 'displayfield',
		        		itemId: 'pendingDisbursement',
		        		labelWidth :'auto',
				        fieldLabel: getCommonTranslation('NO_OF_DISBURSEMENT_PENDING'), //No. of Disbursements Pending
				        name: 'pendingDisbursement',
				        value: '0'
				    },{
				    	xtype:'grid',
				    	itemId:'viewDisbursementGrid',				    	
				    	viewConfig : {
				    		stripeRows : CONSTANTS.STRIPEROWS		
				    	},		  
				    	store:'scholarships.ViewAwardeesDisbursementStore',
				    	border: true,	
				    	autoScroll:true,
				    	columns :[
				        {
				    		header : getCommonTranslation('DISBURSEMENT_ID'),//Disbursement ID
				    		dataIndex : 'disbursementId',		
				    		flex:.2
				    	},{
				    		header : getCommonTranslation('DATE'),//Date
				    		dataIndex : 'paymentDate',		
				    		flex:.2,
				    		renderer:function(date) {
				    			return dateRender(date);
				    		}
				    	},{
				    		header : getCommonTranslation('TOTAL_AMT_RECEIVED'),//Total Amount Received
				    		dataIndex : 'totalAmountReceived',		
				    		flex:.2
				    	},{
				    		header : getCommonTranslation('AMOUNT_ADJUSTED'),//Amount Adjusted
				    		dataIndex : 'adjustedAmount',		
				    		flex:.2
				    	},{
				    		header : getCommonTranslation('AMOUNT_DISBURSED'),//Amount Disbursed
				    		dataIndex : 'amountDisbursed',		
				    		flex:.2
				    	}],
				    	dockedItems: [{
			                xtype: 'toolbar',
			                dock: 'bottom',
			                items: [{
			                    xtype: 'custompagingtoolbar',
			                    plugins: ['pagesize'],
			                    store: 'scholarships.ViewAwardeesDisbursementStore',
			                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			                    displayInfo: true
			                }]
			            }]
				    }]
			}]
		});