/**
 * @author Rohit Sharma
 * 
 * This component is used for to show associate academy locations,programs,courses.     
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.ScholarshipApplyToSearchTab', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.scholarshipApplyToSearchTab',
    plain: true,
    autoScroll: true,
    reserveScrollbar: true,
    cls: 'horizontalScrollingFixed',
    title: getCommonTranslation('SEARCH'),
    layout: 'vbox',
    defaults: {
    	width: '100%'
    },
    items: [{
    	xtype: 'grid',
    	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    	store: 'scholarships.ScholarshipApplyToGridStore',
    	border: true,
    	viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        headerFix: {
    		headerFix: true,
    		portalIdsWithStructure: {
    			'scholarshipApplyToSearchTab': 1
    		}
        },
        dockedItems: [{
            xtype: 'toolbar',
            dock: 'bottom',
            itemId: 'dockedItemsItemId',
            items: [{
                xtype: 'custompagingtoolbar',
                plugins: ['pagesize'],
                store: 'scholarships.ScholarshipApplyToGridStore',
                emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                displayInfo: true
            }]
        }],
        tbar: [{
        	xtype: 'button',
        	itemId: 'btnAdd',
        	glyph: ICONGLYPH.ADDGLYPH,
        	tooltip :getCommonTranslation('ADD')
        }, {
        	xtype: 'button',
        	itemId: 'btnDelete',
        	glyph: ICONGLYPH.DELETEGLYPH,
        	cls: 'CustomToolbarBtnReject',
        	tooltip :getCommonTranslation('DELETE')
        }],
        columns: [{
            header: getCommonTranslation('FACULTY'),
            dataIndex: 'academyLocationName',
            flex: 1
        }, {
            header: getCommonTranslation('FACULTY_CAMPUS'),
            dataIndex: 'locationName',
            flex: 1
        },{
            header: getCommonTranslation('PROGRAM_GROUP'),
            dataIndex: 'programGroupName',
            flex: 1
        },{
            header: getCommonTranslation('PROGRAM'),
            dataIndex: 'programName',
            flex: 1
        }, {
            header: getCommonTranslation('BATCH'),
            dataIndex: 'batchName',
            flex: 1
        }]
    }]
});