
Ext.define('Academia.view.securitysetup.UserPrivilegeGridWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.userPrivilegeGridWindow',
    title: getCommonTranslation('ASSIGN_PRIVILAGES'),
    //autoScroll: true,
    layout: 'fit',
    height: 'auto',
    height: '80%',
    width: '80%',
    frame: true,
    modal: true,
    
    items: [{
		xtype:'grid',
		//alias:'widget.userPrivilegeGrid',
		itemId: 'userPrivilegeGrid',
		store:'securitysetup.UserRolePrivilege',
		columns:[{
			hidden:true,
			dataIndex:'featurePrivilegeId'
		},{
			header:'Portal',
			dataIndex:'portal',
			flex:0.5,
			renderer:function(value) {
				return value.value;
			}			
		},{
			header:'Module',
			dataIndex:'module',
			flex:0.4,
			renderer:function(value) {
				return value.value;
			}	
		},{
			header:'Submodule',
			dataIndex:'subModule',
			flex:0.4,
			renderer:function(value) {
				return value.value;
			}	
		},{
			header:'Feature',
			dataIndex:'featureName',
			sortable: true
/*			flex:0.5,
			renderer:function(value) {
				return value.value;
			}	*/
		},{
			header:'Privilege',
			dataIndex:'privilege',
			flex:0.5,
			renderer:function(value) {
				return value.value;
			}	
		},{
			xtype:'checkcolumn',
			header:'Override',
		     inputValue :true,
	         uncheckedValue : false,
			dataIndex : 'whetherGranted',
			renderer: function(value, metadata,record) {
				var data=record.raw;
				
				 var disabled=!data.whetherOverrideAllowed;
				 if(disabled){
					 metadata.style+= ' opacity:0.3';
					 value=data.whetherGranted;
				 }
				
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			},
			 processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
				 if (type == 'mousedown' || (type == 'keydown' && (e.getKey() == e.ENTER || e.getKey() == e.SPACE))) {
					var record = view.panel.store.getAt(recordIndex);
					var data=record.raw;
					var disabled=!data.whetherOverrideAllowed;
					 //do not change data and fire checkchange event if it's disabled
					 view.focusRow(recordIndex);
					 if (!disabled) {
		                        dataIndex = this.dataIndex;
		                        checked = !record.get(dataIndex);
		                        record.set(dataIndex, checked);
		                        this.fireEvent('checkchange', this, recordIndex, checked);
		              }
					 return false;
	                }
	            }				
		}],
		tbar:[{
			xtype:'customcombobox',
			store:'securitysetup.PortalStore',
			displayField:'portalName',
			valueField:'portalName',
			editable:false,
			itemId:'comboPortal',
			emptyText:'Select Portal',
			queryMode:'local'
		},{
			xtype:'customcombobox',
			store:'securitysetup.ModuleStore',
			displayField:'moduleName',
			valueField:'id',
			editable:false,
			disabled:true,
			itemId:'comboModule',
			emptyText:'Select Module'	
		},{
			xtype:'customcombobox',
			store:'securitysetup.SubModuleStore',
			displayField:'moduleName',
			valueField:'id',
			editable:false,
			disabled:true,
			itemId:'comboSubModule',
			emptyText:'Select Sub Module'
		},{
			xtype:'button',
	    	text:getCommonTranslation('SAVE'),
	    	action:'save',
	    	itemId:'btnSavePrivilege'
		},{
			xtype:'button',
			text:getCommonTranslation('CLEAR_SEARCH'),
			itemId:'btnResetFilter'
		}]
    }]
}
);