/**
 * @author Pritam.Patil
 * This is used for Never Locked User search Form
 */
Ext.define('Academia.view.securitysetup.unlockuser.NeverLockedUserSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.neverlockedusersearchform',
    frame: false,
    autoScroll:false,
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	xtype:'customcombobox',
            fieldLabel: getCommonTranslation('ACADLOCTT'),
            name: 'ACADEMY_LOCATION_ID',
			store : 'common.AssignedAcademyLocations',
			valueField : 'id',
			displayField : 'academyLocationName',
			editable:false,
			forceSelection :true,
//			allowBlank:false
        },{
	    	  xtype: 'customcombobox',
	          name: 'USER_BELONGS_TO',
	          fieldLabel: getCommonTranslation('USER_BELONGS_TO'),
	          store: 'securitysetup.unlockUser.userBelongsToStore',
	          valueField: 'id',
	          displayField: 'value',
	          triggerAction: 'all',
	          forceSelection: true,
	          editable: false,
	          labelAlign: 'top'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'radiofield',
            boxLabel: getCommonTranslation('STUDENTS'),
            name: 'USERS_GROUP_NAME',
            itemId: 'studentsRadioBtn',
            inputValue: 'Student'
        }, {
            xtype: 'radiofield',
            boxLabel: getCommonTranslation('OTHERS'), //Alpha numeric
            name: 'USERS_GROUP_NAME',
            inputValue: 'Others',
            itemId: 'otherRadioBtn'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'neverLockedUserSearchButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'neverLockedUserClearSearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});