/**
 * @author pritam.patil
 *  Requester Details Panel 
 */
Ext.define('Academia.view.servicerequest.common.RequesterDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.requesterdetailspanel',
    items:[{
        xtype: 'displayfield',
        hideLabel:true,
        itemId: 'pendingDaysMessageField',
        name: 'pendingDaysMessage',
        hidden : true,
        style :{
        	marginLeft : '5px'
        }
    },{
        xtype: 'hidden',
        name: 'batchEndDate',
        itemId: 'batchEndDateItemId',
        hidden: true
    },{
        xtype: 'hidden',
        name: 'requestStatusId',
        itemId: 'requestStatusId',
        hidden: true
    }, {
    	xtype: 'hidden',
        name: 'dataToBeChangedId',
        itemId: 'dataToBeChangedId',
        hidden: true
    },{
    xtype: 'fieldset',
    title: getServiceRequestTranslation('REQUESTER_DETAILS'),
    style:{'margin-top':'67px !important'},
    cls: 'requesterDetailsFieldSetCls',
    collapsed: false,
    items: [{
    	xtype: 'button',
    	text: '',
    	itemId: 'studentHyperLink',
    	cls: 'hyperlinkBtn',
    	hidden:true
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign : 'top'
        },
        items: [{
            xtype: 'displayfield',
            fieldLabel: getServiceRequestTranslation('REQUESTER_NAME'),
            itemId: 'name',
            name: 'studentName'
        }, {
            xtype: 'displayfield',
            fieldLabel: getServiceRequestTranslation('EMAIL'),
            itemId: 'email',
            name: 'email',
            style: {	
                'word-wrap': 'break-word'
            },
        },{
            xtype: 'displayfield',
            fieldLabel: getServiceRequestTranslation('MOBILE'),
            itemId: 'mobile',
            name: 'mobile',
            value: ''
        } , {
            xtype: 'displayfield',
            fieldLabel: getServiceRequestTranslation('DEPARTMENT'),
            itemId: 'department',
            name: 'department',
            hidden:true
        },{
            xtype: 'displayfield',
            fieldLabel: getServiceRequestTranslation('SUB_DEPARTMENT'),
            itemId: 'subDepartment',
            name: 'subDepartment',
            hidden:true
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign : 'top'
        },
        items: [{
            xtype: 'displayfield',
            fieldLabel: getServiceRequestTranslation('ADMISSION_DATE'),
            itemId: 'admissionDateDisplay',
            name: 'admissionDate'
        },{
            xtype: 'displayfield',
            fieldLabel: getServiceRequestTranslation('PROGRAM'),
            itemId: 'program',
            name: 'program'
        }, {
            xtype: 'displayfield',
            fieldLabel: getServiceRequestTranslation('BATCH'),
            itemId: 'batch',
            name: 'batch'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign : 'top'
        },
        items: [{
            xtype: 'displayfield',
            fieldLabel: getCommonTranslation('PERIOD_NAME'),
            itemId: 'periodId',
            name: 'period'
        }, {
            xtype: 'displayfield',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            itemId: 'academiaName',
            cls:"breakWordCls",
            name: 'academiaName'
        },{
            xtype: 'displayfield',
            fieldLabel: getCommonTranslation('CAMPUS'),
            itemId: 'campusId',
            name: 'campus'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        height: 'auto', //if all fields inside fieldcontainer are hidden it's height should be zero
        defaults: {
            width: 226,
            labelAlign : 'top'
        },
        items: [{
            xtype: 'displayfield',
            fieldLabel: getHostelTranslation('HOSTEL_NAME'),
            itemId: 'hostelName',
            name: 'hostelName',
            hidden: true
        }, {
            xtype: 'displayfield',
            fieldLabel: getHostelTranslation('BUILDING_NAME'),
            itemId: 'buildingName',
            name: 'buildingName',
            hidden: true
        }, {
            xtype: 'displayfield',
            fieldLabel: getHostelTranslation('ROOM_NO'),
            itemId: 'roomNo',
            name: 'roomNo',
            hidden: true
           
        }]
    }]
    }]
    
});