/**
 * @author pritam.patil
 * This is used for complain details Form
 */
Ext.define('Academia.view.servicerequest.complaintrequest.ComplaintDetailsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.complaintdetailsform',
    frame: false,
    border: false,
    autoScroll: true,
    margin: 10,
    plugins: "formlabelrequired",
    bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,	
    items: [{
    	xtype:'panel',
    	items:[{
		xtype:'hidden',			
    	name:'id',
    	itemId:'id',
    },{
       	xtype:'hidden',			
      	name:'version'
  	},{
		xtype:'nestedJsonCombo',
		name:'complaintTypeSetting',
		itemId:'settingId',
		hidden:true
	},{
        xtype: 'displayfield',
        hideLabel:true,
        itemId: 'pendingDaysMessageField',
        name: 'pendingDaysMessage',
        hidden : true
		},{  
			xtype: 'form',
			itemId: 'requesterDeatilsForm',
		    title: getServiceRequestTranslation('GRIEVANCE_DETAILS'),
			frame:true,
		    collapsed: false,
			margin: 0,
			cls: 'highlighted-form-fields-cls',
	  	  items: [{
	        xtype: 'fieldcontainer',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 226,
	            labelAlign : 'top'
	        },
	        items: [{
	            xtype: 'displayfield',
				editable: false,
	            fieldLabel: getServiceRequestTranslation('REQUESTER_NAME'),
	            itemId: 'name',
	            name: 'studentName'
	        }, {
	            xtype: 'displayfield',
				editable: false,
	            fieldLabel: getServiceRequestTranslation('EMAIL'),
	            itemId: 'email',
	            name: 'email',
	            style: {	
	                'word-wrap': 'break-word'
	            },
	        },{
	            xtype: 'displayfield',
				editable: false,
	            fieldLabel: getServiceRequestTranslation('MOBILE'),
	            itemId: 'mobile',
	            name: 'mobile',
	            value: ''
	        } ]
	    }, {
	        xtype: 'fieldcontainer',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 226,
	            labelAlign : 'top'
	        },
	        items: [{
	            xtype: 'displayfield',
				editable: false,
	            fieldLabel: getServiceRequestTranslation('ADMISSION_DATE'),
	            itemId: 'admissionDateDisplay',
				name: 'admissionDate'
	        },{
	            xtype: 'displayfield',
				editable: false,
	            fieldLabel: getServiceRequestTranslation('PROGRAM'),
	            itemId: 'program',
	            name: 'program'
	        }, {
	            xtype: 'displayfield',
				editable: false,
	            fieldLabel: getServiceRequestTranslation('BATCH'),
	            itemId: 'batch',
	            name: 'batch'
	        }]
	    }, {
	        xtype: 'fieldcontainer',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 226,
	            labelAlign : 'top'
	        },
	        items: [{
	            xtype: 'displayfield',
				editable: false,
	            fieldLabel: getCommonTranslation('PERIOD_NAME'),
	            itemId: 'periodId',
	            name: 'period'
	        }, {
	            xtype: 'displayfield',
				editable: false,
	            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
	            itemId: 'academiLocationName',
	            cls:"breakWordCls",
	            name: 'academiLocationName',
				editable: false
	        },{
	            xtype: 'displayfield',
	            fieldLabel: getCommonTranslation('CAMPUS'),
	            itemId: 'campusId',
				editable: false,
	            name: 'campus'
	        }]
	    }]
   
		},{
        xtype: 'form',
        title: getServiceRequestTranslation('BASIC_DETAILS'),
        collapsed: false,
        frame:true,
      //  margin: 0,
        style: {
            marginLeft: '0px',
			marginRight: '0px',
            marginTop: '2px',
			marginBottom : '0px'
        },
        items: [{
        	xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            layout: 'hbox',
            items: [{
                    xtype: 'displayfield',
                    itemId: 'enteredBy',
                    fieldLabel: getServiceRequestTranslation('ENTERED_BY'),
                    name: 'enteredBy'
            	}]
        },{
        xtype: 'fieldcontainer',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
            store: 'servicerequest.complaintrequest.ComplaintTypes',
            valueField: 'id',
            name : 'complaintTypeId',
            itemId: 'complaintTypeId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        },{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_DATE'),
            name: 'requestDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'complainDateId',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            maxValue: new Date()
          }]
    }, {
        xtype: 'fieldcontainer',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [ {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_AGAINST'),
            store: 'servicerequest.complaintrequest.ComplaintAgainsts',
            name : 'against',
            valueField: 'id',
            itemId: 'complaintAgainstId',
            displayField: 'value',
            allowBlank: false,
            editable: false
        },{
            xtype: 'livesearchcombo',
            labelAlign: 'top',
            displayField: 'value', 
        	valueField: 'id', 
            name: 'complaintAgainstPerson',
            fieldLabel: getServiceRequestTranslation('SELECT_PERSON'),
            store: 'Academia.store.servicerequest.complaintrequest.ComplaintPersons',
            itemId: 'selectPersonId',
            allowBlank: false,
            disabled : true,
            displayTpl: new Ext.XTemplate(
             		'<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["value"]]}' +
             		'</tpl>'
             		)
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId : 'complaintByFieldContainer',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_BY'),
            store: 'servicerequest.complaintrequest.ComplaintBy',
            name : 'complaintBy',
            valueField: 'id',
            itemId: 'complaintById',
            displayField: 'value',
            allowBlank: false,
            editable: false
        },{
                xtype: 'livesearchcombo',
                labelAlign: 'top',
                name: 'complainant',
                displayField: 'value', 
            	valueField: 'id', 
                fieldLabel: getServiceRequestTranslation('GRIEVANCE_NAME'),
                store: 'Academia.store.servicerequest.complaintrequest.Complaintant',
                itemId: 'selectComplaintantId',
                allowBlank: false,
                disabled : true,
                displayTpl: new Ext.XTemplate(
                 		'<tpl for="."between=" ">',
                 		'{[typeof values === "string" ? values : values["value"]]}' +
                 		'</tpl>'
                 		)
        }]},{
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            layout: 'vbox',
            items: [{
            	xtype: 'customcombobox',
            	name: 'internalResourceId',
            	itemId: 'facilityCodeId',
            	fieldLabel: getServiceRequestTranslation('FACILITY_CODE'),
            	store: 'servicerequest.complaintrequest.FacilityCodes',
            	valueField: 'id',
            	displayField: 'valueCode',
            	queryParam:'name',
            	minChars:3,
            	typeAhead:false,
            	hideTrigger:false,
            	forceSelection:true,
            	//triggerAction: '',
            	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            	//allowBlank:false,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{value}' +
            			'</div>';
            		}
            	}
            },{
                xtype: 'textareafield',
                fieldLabel: getServiceRequestTranslation('FACILITY_DESCRIPTION'),
                name: 'facilityDescription',
                width : 400,
                maxLength : 255,
                //allowBlank: false,
                itemId: 'facilityDescriptionId'
            },{
                xtype: 'textareafield',
                fieldLabel: getServiceRequestTranslation('GRIEVANCE_REMARKS'),
                name: 'remarks',
                width : 400,
                maxLength : 255,
                enforceMaxLength : true,
                itemId: 'complaintRemarksId',
                allowBlank: false
            }]
        },{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            itemId: 'btnSaveComplaint',
            text: getCommonTranslation('SUBMIT'), 
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            ui:'CustomBtnCancel',
            itemId: 'cancelIdComplaint',
            style:{
            	marginLeft:'10px'
            },
            handler : function(){
            	this.up('form').getForm().reset();
            },
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            hidden: true,
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
    }]}]
});