/**
 * @author Bhanu Pratap Singh
 *Employee Leave request Details Panel 
 */
Ext.define('Academia.view.servicerequest.leavefineapplyrelatedrequest.EmployeeLeaveDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.employeeleavedetailgrid',
	store: 'leavemanagement.EmployeeLeaveDetailStore',
	title: getCommonTranslation('AVAILABLE_LEAVES'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'leavemanagement.EmployeeLeaveDetailStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	 tbar: [],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getCommonTranslation('LEAVE_TYPE'),
		dataIndex: 'leaveTypeName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COMBINABLE'),
		dataIndex: 'combinableCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(record.data.combinableCount==null){
				return "-";
			}
		}
	},{
		header:getCommonTranslation('ALLOW_ADVANCE_CREDIT') ,
		dataIndex: 'allowAdvance',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.allowAdvance){
					return "<span style=\'color:green\'>Yes</span>";
				} else {
					return "<span style=\'color:red\'>No</span>";
				}
			}                        
		}
	},{
		header:getCommonTranslation('TOTAL_CREDIT'),
		dataIndex: 'totalCredit',
		flex:.1,
		sortable:true
	},{
		header: getCommonTranslation('LEAVE_AVAILED'),
		dataIndex: 'leaveAvailed',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('AVAILABLE_LEAVES'),
		dataIndex: 'remainingLeaves',
		flex:.1,
		sortable:true
	}]
});
