/**
* @author Deepak Sharma
 */
Ext.define('Academia.view.servicerequest.studentservicerequest.StudentTransferRequestDetailsPanel', {
    extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.studenttransferrequestdetailspanel',
    frame: false,
    border: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    },{
        xtype: 'hidden',
        name: 'fromALId'
    }, {
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true
    }, {
        xtype: 'requesterdetailspanel',
        itemId: 'requesterDetails',
        style: {
            marginBottom: '0px'
        }
    }, {
        xtype: 'basicdetails',
        itemId: 'programBasicDetails',
        style: {
            marginBottom: '-29px'
        }
    },  {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('ACADEMIC_TERM'),
            name: 'academicTerm',
            store: 'common.StudentJouneryAcademicTermStore',
            valueField: 'id',
            itemId: 'academicTermId',
            displayField: 'value',
            allowBlank: true,
            editable: false,
            hidden : true,
            queryMode: 'local'
        },
        {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('FROM_ACADEMY_LOCATION'),
            name: 'fromAcademicLocation',
            store: 'common.StudentJouneryAcademyLocationStore',
            valueField: 'id',
            itemId: 'fromAcademicLocationId',
            displayField: 'value',
            allowBlank: true,
            editable: false,
            hidden : true,
            disabled:true,
            queryMode: 'local'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('FROM_PROGRAM'),
            name: 'fromProgramId',
            store: 'servicerequest.programcoursesectiontransfer.FromPrograms',
            valueField: 'id',
            itemId: 'fromProgramId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('FROM_BATCH'),
            name: 'fromBatch',
            store: 'servicerequest.programcoursesectiontransfer.FromStudentJouneryBatchStore',
            valueField: 'id',
            itemId: 'fromBatchId',
            displayField: 'value',
            allowBlank: true,
            editable: false,
            disabled:true,
            hidden : true,
            queryMode: 'local'
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('FROM_PERIOD'),
            name: 'fromPeriod',
            store: 'servicerequest.programcoursesectiontransfer.FromStudentJouneryPeriodStore',
            valueField: 'id',
            itemId: 'fromPeriodId',
            displayField: 'value',
            allowBlank: true,
            disabled:true,
            editable: false,
            hidden : true,
            queryMode: 'local'
        }
        ]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('STUDENT_TRANSFER_TO_ACADEMY_LOCATION'),
            name: 'toALId',
            store: 'organization.academylocations.ActiveAcademyLocationStore',
            valueField: 'id',
            itemId: 'toAcademyLocationItemId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('TO_PROGRAM'),
            name: 'toProgramId',
            store: 'servicerequest.programcoursesectiontransfer.ToPrograms',
            valueField: 'id',
            itemId: 'toProgramId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local',
            disabled:true
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('STUDENT_TRANSFER_TO_BATCH'),
            name: 'toBatchId',
            store: 'servicerequest.programcoursesectiontransfer.ToBatches',
            valueField: 'id',
            itemId: 'toBatchId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local',
            disabled:true
        }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('STUDENT_TRANSFER_TO_PERIOD'),
            name: 'toPeriodId',
            store: 'servicerequest.programcoursesectiontransfer.programTransferToPeriodStore',
            valueField: 'id',
            itemId: 'toPeriodId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local',
            disabled:true
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('SEAT_TYPE'),
            name: 'toSeatType',
            store: 'admission.admissionCommon.SeatTypesByBatchIdsStore',
            valueField: 'id',
            itemId: 'toSeatTypeId1',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local',
            disabled:true
        }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'vbox'
        },
        width: 680,
        style: {
             marginLeft: '20px',
             marginTop: '20px'
        },
        items: [{
        xtype: 'displayfield',
        width: 680,
        labelWidth: 680,
        cls:'hideDisplayText',
        labelSeparator:' ',
        fieldLabel: getCommonTranslation('ST_AUTHORIZED_DECLARATION'),
        itemId: 'authorizeDeclarationDetails',
        name: 'authorizeDeclarationDetails'
        },{
        xtype: 'checkboxfield',
        width: '100%',
        cls:'acceptCheckBox',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('PT_AUTHORIZED_CHECKBOX'),
        name: 'authorizeDeclaration',
        itemId:'authorizeDeclarationId',
        inputValue : true,
        afterBoxLabelTpl:' ',
        uncheckedValue: false
        },{
        xtype: 'fieldset',
        itemId: 'visaRefusal',
        width: '100%',
        cls: 'fieldSetDFRCls',
        title: getCommonTranslation("VISA_REFUSAL"),
        style: {
        marginLeft: '5px',
        marginTop: '10px !important',
        padding: '0px !important'
        },
        items: [{
        xtype: 'checkboxfield',
        width: '100%',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('VISA_REFUSAL_CONTENT'),
        name: 'visaRefusalCheck',
        itemId:'visaRefusalCheck',
        inputValue : true,
            afterBoxLabelTpl:' ',
        uncheckedValue: false
        }]
        },{
        xtype: 'fieldset',
        itemId: 'studiedInUk',
        width: '100%',
        cls: 'fieldSetDFRCls',
        title: getCommonTranslation("STUDIED_IN_UK"),
        style: {
        marginLeft: '5px',
        marginTop: '10px !important',
        padding: '0px !important'
        },
        items: [{
        xtype: 'checkboxfield',
        width: '100%',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('STUDIED_IN_UK_CONTENT'),
        name: 'studiedInUkCheck',
        itemId:'studiedInUkCheck',
        inputValue : true,
            afterBoxLabelTpl:' ',
        uncheckedValue: false
        }]
        },{
        xtype: 'fieldset',
        itemId: 'healthInsuranceId',
        width: '100%',
        cls: 'fieldSetDFRCls',
        title: getCommonTranslation("PT_HEALTH_INSURANCE_FC"),
        style: {
        marginLeft: '5px',
        marginTop: '10px !important',
        padding: '0px !important'
        },
        items: [{
        xtype: 'checkboxfield',
        width: '100%',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('PT_HEALTH_INSURANCE'),
        name: 'healthInsuranceCheck',
        itemId:'healthInsuranceCheckId',
        inputValue : true,
            afterBoxLabelTpl:' ',
        uncheckedValue: false
        }]
        },{
        xtype: 'fieldset',
        itemId: 'scholarshipId',
        width: '100%',
        cls: 'fieldSetDFRCls',
        title: getCommonTranslation("PT_SCHOLARSHIP_FC"),
        style: {
        marginLeft: '5px',
        marginTop: '10px !important',
        padding: '0px !important'
        },
        items: [{
        xtype: 'checkboxfield',
        width: '100%',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('PT_SCHOLARSHIP'),
        name: 'scholarshipCheck',
        itemId:'scholarshipCheckId',
        inputValue : true,
            afterBoxLabelTpl:' ',
        uncheckedValue: false
        }]
        },{
        xtype: 'fieldset',
        itemId: 'medicalIssuesId',
        width: '100%',
        cls: 'fieldSetDFRCls',
        title: getCommonTranslation("PT_MEDICAL_ISSUES_FC"),
        style: {
        marginLeft: '5px',
        marginTop: '10px !important',
        padding: '0px !important'
        },
        items: [{
        xtype: 'checkboxfield',
        width: '100%',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('PT_MEDICAL_ISSUES'),
        name: 'medicalIssuesCheck',
        itemId:'medicalIssuesCheckId',
        inputValue : true,
            afterBoxLabelTpl:' ',
        uncheckedValue: false
        },{
        	xtype: 'displayfield',
        	width: '100%',
        	labelWidth: '100%',
        	cls:'hideDisplayText',
        	labelSeparator:' ',
        	fieldLabel: getCommonTranslation('STD_TRANSFER_STATEMENT'),
        	itemId: 'stdTransferStatementId',
        	name: 'stdTransferStatement'
        }
       ]},{
        xtype: 'checkboxfield',
        width: '100%',
        cls:'acceptCheckBox',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('PT_UP_TO_DATE_CHECKBOX'),
        name: 'upToDateDetails',
        itemId:'upToDateDetailsId',
        inputValue : true,
        afterBoxLabelTpl:' ',
        uncheckedValue: false
        },{
        xtype: 'checkboxfield',
        width: '100%',
        cls:'hideCheckBox',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('STUDENT_DECLARATION'),
        name: 'studentdeclaration',
        itemId:'studentDeclarationId',
        inputValue : true,
        afterBoxLabelTpl:' ',
        uncheckedValue: false
        },{
        xtype: 'displayfield',
        width: 680,
        labelWidth:680,
        labelSeparator:' ',
        cls:'hideDisplayText',
        itemId: 'studentDeclarationDetails',
        fieldLabel: getCommonTranslation('STUDENT_DECLARATION_CONTENT_ST'),
        name: 'studentDeclarationDetails'
        }, {
        xtype: 'checkboxfield',
        width: '100%',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('FOR_STUDENTS_APPLYING'),
        name: 'studentApply',
        cls:'hideCheckBox',
        itemId:'studentApplyId',
        inputValue : true,
        afterBoxLabelTpl:':',
        uncheckedValue: false
        },{
        xtype: 'displayfield',
        width: 680,
        cls:'hideDisplayText',
        labelWidth:680,
        labelSeparator:' ',
        itemId: 'forStudentsApplyingDetails',
        fieldLabel: getCommonTranslation('FOR_STUDENTS_APPLYING_CONTENT'),
        name: 'forStudentsApplyingDetails'
        },{
        xtye:'checkboxgroup',
        itemId:'isConfirmation',
        allowBlank: false,
        margin:' 0 0 0 -10',
        items:[{
        xtype: 'checkboxfield',
        width: '100%',
        labelAlign: 'right',
        cls:'acceptCheckBox',
        boxLabel:getCommonTranslation('ACCEPT_STUDENT_DECLARATION'),
        name: 'confirmation',
        itemId:'confirmationId',
        inputValue : true,
        afterBoxLabelTpl:'.',
        uncheckedValue: false
        }]
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '17px',
            marginTop: '24px'
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            itemId: 'studentTransferSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true
        }]
    }]
});
