/**
 * @author Amit Gupta
 * This component is used  to show Term and Condition transaction View Grid
 */
Ext.define('Academia.view.setup.dashboard.TermsandConditionReportViewGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.termsandconditionreportviewgrid',
    collapsible: false,
    title : getCommonTranslation('TERMS_CONDITIONS_LOG_REPORT'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
    	header: getCommonTranslation('TERMCONDITION_IDCODE'),
        dataIndex: 'code',
        flex: .1
    },{
        header: getCommonTranslation('TERMCONDITION_FULL_NAME'),
        dataIndex: 'name',
        sortable: true,
        flex: .1
    }, {
        header: getCommonTranslation('TERMCONDITION_USER_TYPE'),
        dataIndex: 'userType',
        sortable: true,
        flex: .1
    }, {
        header: getCommonTranslation('TERMCONDITION_DATE'),
        dataIndex: 'acceptanceDateStr',
        sortable: true,
        flex: .1
		
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();

        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.setup.dashboard.TermsandConditionReportViewStore');
    }
});