/**
 * @author Pritam.Patil
 * This component is used  to show transaction View Grid
 */
Ext.define('Academia.view.setup.dashboard.TranactionViewGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.tranactionviewgrid',
    collapsible: false,
    title : getCommonTranslation('TABLE_DATA_CHANGE_REPORT'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
    	header: getCommonTranslation('ID'),
        dataIndex: 'id',
        hidden: true
    },{
        header: getCommonTranslation('TRANSACTION'),
        dataIndex: 'transactionCode',
        sortable: true,
        flex: .4
    }, {
        header: getPersonModuleTranslation('USER'),
        dataIndex: 'userName',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('DATE'),
        dataIndex: 'transactionDate',
        sortable: true,
        flex: .1,
		renderer:function(date) {
			return dateRender(date);
		}

    }, {
        header: getCommonTranslation('TIMES_USED'),
        dataIndex: 'count',
        align: 'center',
        sortable: true,
        flex: .1,
        renderer  : function(Value) {
            return '<a href="#">'+Value+'</a>';
        }

    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();

        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.setup.dashboard.TransactionViewStore');
    }
});