/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.setup.translationmapping.TranslationMappingSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.translationmappingsearch',  
	plugins : "formlabelrequired",
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items :[{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('TEMPLATE_TYPE'),
			itemId: 'templateTypeTranslation',
			name: 'templateTypeTranslation', 
			store:Ext.create('Academia.store.setup.templatemapping.TemplateType'),
			valueField:'id',
			displayField:'value',
			allowBlank:false					
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			itemId: 'templateNameTranslation',
			name: 'templateNameTranslation',
			store:Ext.create('Academia.store.setup.templatemapping.TemplateName'),
			valueField:'id',
			displayField:'value',
			queryParam:'reportTemplateName',
			minChars:3,
			allowBlank:false,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			},
			disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtnTranslation',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getExaminationTranslation('RESET'),
			itemId: 'resetBtnTranslation',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}
		]
	}]
});