/**
 * @author Deepak Mathur
 */
var sgAppointmentDetailsGridStore =  Ext.create('Academia.store.sgappointment.sgappointment.SGAppointmentGridStore');
Ext.define('Academia.view.sgappointment.sgappointment.SGAppointmentDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sgappointmentdetailgrid',
	title: getServiceRequestTranslation('SG_MANAGE_APPOINTMENTS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   
		var store = sgAppointmentDetailsGridStore;
		grid.addExportToolBarItems(grid);
		Ext.apply(this, {
			store: store        
		});

		this.callParent(arguments);
		var custompagingtoolbar=grid.down('custompagingtoolbar');
		if(custompagingtoolbar){
			custompagingtoolbar.bindStore(store);        	
		}

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation('BOOKING_ID'),
		dataIndex: 'bookingId',
		flex:.1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('APPOINTEE_NAME'),
		dataIndex: 'appointeeName',
		flex:.1,
		sortable:true,
	},{
		header:  getCommonTranslation('REASON_TO_MEET'),
		dataIndex: 'sgReasonForVisit',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return value.value;
			}else{
				return "-";
			}			
		}   
	
	},{
		header:  getCommonTranslation('APPOINTMENT_DATE'),
		dataIndex: 'appointmentDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocation',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return value.value;
			}else{
				return "-";
			}
		}  
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'program',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return value.value;
			}else{
				return "-";
			}
		}  
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batch',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return value.value;
			}else{
				return "-";
			}
		}  
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'progBatchSeatConfig',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return value.value;
			}else{
				return "-";
			}
		}   
	},{
		header:  getCommonTranslation('VISIT_STATUS'),
		dataIndex: 'sgVisitStatus',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return value.value;
			}else{
				return "-";
			}
		}   
	
	},{
		header:  getCommonTranslation('PERSON_TO_MEET'),
		dataIndex: 'personToMeet',
		flex:.1,
		sortable:true,
	},{
		header:  getCommonTranslation('BOOKING_DATE'),
		dataIndex: 'bookingDate',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('APPOINTEE_CONTACT_NO'),
		dataIndex: 'appointeeContactNo',
		flex:.1,
		hidden:true,
		sortable:true,
	},{
		header:  getCommonTranslation('APPOINTMENT_COMPLETION_DATE_TIME'),
		dataIndex: 'appointmentCompletionDateTime',
		flex:.2,
		sortable:true,
		hidden:true,
		renderer:function(date) {
			return '<div>'+dateRender(date)+'</div>'+" "+'<div>'+timeRender(date)+'</div>';
		}
	},{
		header:  getCommonTranslation('VISIT_TIME'),
		dataIndex: 'visitTime',
		flex:.1,
		sortable:true,
		hidden:true,
        renderer:function(value, record){
        	return timeRender(value);
        }
	},
	{
		header:  getCommonTranslation('OUT_TIME'),
		dataIndex: 'expectedOutTime',
		flex:.1,
		sortable:true,
		hidden:true,
        renderer:function(value, record){
        	return timeRender(value);
        }
	},{
		header: getCommonTranslation('ENTRY_BY'),
		dataIndex: 'entryByName',
		flex:.1,
		sortable:true,
		hidden:true
	}]
}); 

