/**
 * 
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentOwnProgressReportGrid', {
	alias: 'widget.studentownprogressreportgrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store:'student.postGraduateManagement.StudentOwnProgressReportGridStore',
	title: getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.postGraduateManagement.StudentOwnProgressReportGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns : [ {
		header: getCommonTranslation('PROGRESS_REPORT_START_DATE'),
		dataIndex: 'progressReportStartDate',
		ItemId: 'progressReportStartDate',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('PROGRESS_REPORT_END_DATE'),
		dataIndex: 'progressReportEndDate',
		ItemId: 'progressReportEndDate',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('PROGRESS_REPORT_RATING'),
		dataIndex: 'reportRating',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.reportRating.value;
			}                        
		}
	},{
		header : getPersonModuleTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'studentOwnProgressReportDocuments',
		flex:1,
		sortable:true,
		renderer:function(value, meta, record){
			console.log('record='+record)
			if(!isNullOrEmpty(value)) {
				if(record.data.studentOwnProgressReportDocuments.length>1) {					
					return '<a href=#>'+record.data.studentOwnProgressReportDocuments.length+'<a>';
				} else if(record.data.studentOwnProgressReportDocuments.length==1) {
					return '<a href=#>'+record.data.studentOwnProgressReportDocuments[0].name+'<a>';
				} 
			}                        
		}
	},{
		header: getCommonTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		ItemId: 'auditDateItem',
		sortable: true,
		hidden:true,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		ItemId: 'auditIdItem',
		flex: 1,
		sortable: true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	}]
});