/**
 * 
 * @author Ratnesh jain
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentThesisTitleGrid', {
	alias: 'widget.studentthesistitlegrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getCommonTranslation('STUDENT_THESIS_TITLE'),
	border: true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
		dataIndex: 'program',
		itemId: 'program',
		sortable: true,
		flex: .2,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(record)){
				return record.data.programCode+'/'+record.data.programName;
			}else{
				return  '';
			}
		}
	},{
		header: getCommonTranslation('TITLE'),
		dataIndex: 'title',
		itemId: 'titleItem',
		sortable: true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
				metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
				return value;
			}	
		}
	},{
		header: getCommonTranslation('SHORT_SUMMARY_FOR_GRADUATION'),
		dataIndex: 'shortSummaryForGraduation',
		itemId: 'shortSummaryForGraduationItem',
		sortable: true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
				metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
				return value;
			}	
		}
	},{
		header: getCommonTranslation('SUPERVISOR_SUMMARY_FOR_READING'),
		dataIndex: 'supervisorSummaryForReading',
		itemId: 'supervisorSummaryForReadingItem',
		sortable: true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
				metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
				return value;
			}	
		}
	},{
		header: getCommonTranslation('CLASSIFIED'),
		dataIndex: 'classified',
		itemId: 'classifiedItem',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('APPROVAL_STATUS'),
		dataIndex: 'approvalStatus',
		sortable: true,
		flex: .2,
		renderer: function(value) {
			if (!isNullOrEmpty(value)) {
				value = getPersonModuleTranslation(value);
			} else {
				value = '';
			}
			return value;
		}
	}, {
		header: getCommonTranslation('APPROVAL_DATE'),
		dataIndex: 'approvalDate',
		itemId: 'approvalDateItem',
		sortable: true,
		flex: .2
		/*renderer: function(date) {
            return dateRender(date);
        }*/
	},{
		header: getCommonTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		itemId: 'auditDateItem',
		sortable: true,
		hidden:true,
		flex: .2
		/*renderer: function(date) {
            return dateRender(date);
        }*/
	},{
		header: getCommonTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		itemId: 'auditIdItem',
		sortable: true,
		hidden:true,
		flex: .2
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore(this$.personType);
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function(personType) {
		return Ext.create('Academia.store.student.postGraduateManagement.StudentThesisTitleStore');
	}
});