/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.student.studentprofile.StudentAcademicHistoryWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentacademichistorywin',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '60%',
	width: '70%',
	frame: true,
	title:getExaminationTranslation('STUDENT_ACADEMIC_HISOTORY_DETAILS'),
	items: [{
		xtype: 'form',
		method: 'POST',
		standardSubmit: false,
		plugins : "formlabelrequired",
		itemId : 'studentAcademicHistoryDetailFormId',
//		margin: 0,
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'hidden',
				name:'id'
			},{
	    		xtype:'displayfield',
	    		name:'programName',
	    		fieldLabel:getExaminationTranslation('PROGRAM')
		    },{
	    		xtype:'displayfield',
	    		name:'batchName',
	    		fieldLabel:getExaminationTranslation('BATCH')
		    },{
	    		xtype:'displayfield',
	    		name:'periodName',
	    		fieldLabel:getExaminationTranslation('PERIOD'),
		    },]
		},]
	},{
		xtype: 'grid',
		store : 'student.studentprofile.AcademicsHistoryDetailsStore',
		autoScroll: true,
		itemId : 'studentAcademicHistoryDetailId',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		columns: [{
			header : getProgramandcourseTranslation('COURSE_CODE'),
			dataIndex : 'courseCode',
			flex : .2,
		},{
			header : getProgramandcourseTranslation('COURSE_NAME'),
			dataIndex : 'courseName',
			flex : .2,
		},{
			header : getCommonTranslation('OBTAINED_MARKS'),
			dataIndex : 'obtainedMarks',
			flex : .2,
		},{
			header : getCommonTranslation('TOTAL_MARKS'),
			dataIndex : 'marks',
			flex : .2,
		},{
			header : getExaminationTranslation('OBTAINED_GRADE'),
			dataIndex : 'grade',
			flex : .2,
		},{
			header : getCommonTranslation('RESULT_STATUS'),
			dataIndex : 'status',
			flex : .2,
			renderer:function(value,meta,record){
	        	if(value.toUpperCase() == 'PASS'){
					return "<span style = 'color:green'>Pass</span>";
				} else {
					return "<span style = 'color:red'>Fail</span>";
				}
	        }
		}] 	

	}]
});
