/**
 * 
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.student.studentprofile.StudentMOUGrid',{
	alias : 'widget.studentmougrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store:'personinfo.common.pasthistory.StudentMOUStore',
	title: getCommonTranslation('STUDENT_MOU'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.pasthistory.StudentMOUStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns : [ {
		header: getCommonTranslation('EFFECTIVE_START_DATE'),
		dataIndex: 'effectiveStartDate',
		ItemId: 'effectiveStartDateItemId',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header : getCommonTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'studentMOUDocuments',
		flex:1,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.studentMOUDocuments.length>1) {					
					return '<a href=#>'+record.data.studentMOUDocuments.length+'<a>';
				} else if(record.data.studentMOUDocuments.length==1) {
					return '<a href=#>'+record.data.studentMOUDocuments[0].name+'<a>';
				} 
			}                        
		}
	},{
		header: getPersonModuleTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		ItemId: 'auditDateItemId',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getPersonModuleTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		ItemId: 'auditIdItemId',
		flex: 1,
		sortable: true,
		hidden:false,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	}]
});