Ext.define('Academia.view.studyplanreport.StydyPlanReportFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.stydyPlanReportFilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	layout: 'vbox',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 460,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
			name: 'academyLocationId',
			itemId: 'academyLocationId',
			store:'common.AcademyLocationNameSeparated',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			name : 'admissionId',
			itemId : 'admissionId',
			store : Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch'),
			fieldLabel : getPersonModuleTranslation('ADMISSION_NUMBER'),
			valueField : 'id',
			displayField : 'valueCode',
			queryParam : 'name',
			disabled: true,
			minChars : 3,
			width : 230,
			typeAhead : false,
			hideTrigger : false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction : '',
			forceSelection : true,
			allowBlank : true,
			enableKeyEvents : 'true',
			listConfig : {
				listeners : {
					beforeshow : function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText : getCommonTranslation('SEARCHING'),
				emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl : function() {
					return '<div class="search-item">' + '{code} / {value}' + '</div>';
				}
			},
			listeners:{
				select:function(obj,record){
					obj.admissionId =record[0].data.secondId
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[
			{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name: 'programId',
				itemId: 'programId',
				store : 'program.ProgramSortedSequenceWiseStore',
				displayField: 'valueCode',
				valueField: 'id',
				minChars:3,
				allowBlank:false,
				forceSelection:true,
				queryParam:'qry',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('BATCH'),
				name: 'batchId',
				itemId: 'batchId',
				editable: false,
				allowBlank:false,
				disabled: true,
				store:'program.programbatchdetail.BatchStore',
				displayField: 'value',
				valueField: 'id',
			},{

				xtype: 'multiselectcombofield',
				width: 226,
				name: 'periodIds',
				itemId: 'period',
				editable:true,
				fieldLabel : getAdmissionTranslation('PERIOD'),
				store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
				displayField:'value',
				valueField:'id',
				autoloadStore: false,
				disabled: true,
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
							Ext.defer(function() {
								picker.getEl().dom.style.wordBreak='break-all';
							},200);
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
	},{
		xtype:'fieldcontainer',
		width: '100%',

		items:[{  
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'btnSearch',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true

		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'btnReset',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]
	}]
});