/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRuleApplyToStudentGroupGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.businessruleapplytostudentgroupgrid',
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, true);
		this.callParent(arguments);
	},
	store: 'sunsuccess.BusinessRuleApplyToStudentGroupGridStore',
	title: getCourseTxCommonTranslation('SEARCH_RESULT'),
	border: true,
	refreshStoreData: true,
	headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'businessruleapplytostudentgroupaddsearchtab,applytostudentgroupsearchtab': 1
    	}
    },
	selType:'checkboxmodel',
	selModel: {
		checkOnly : false,
		multiSelect :true,
	    mode: 'SIMPLE'
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'sunsuccess.BusinessRuleApplyToStudentGroupGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		disabled: true,
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		disabled: true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getCommonTranslation('SCHOLARSHIP_ID'),
		dataIndex: 'scholarshipCode'
	}, {
		header: getCommonTranslation('SCHOLARSHIP_NAME'),
		dataIndex: 'scholarshipName',
		flex: 1
	}, {
		header: getCommonTranslation('SCHOLARSHIP_TYPE'),
		dataIndex: 'scholarshipType'
	}, {
		header: getCommonTranslation('ORG_NAME'),
		dataIndex: 'organizationName',
		flex: 1
	}, {
		header: getCommonTranslation('SCHOLARSHIP_AMOUNT_TYPE'),
		dataIndex: 'scholarshipAmountType',
		flex: 1
	}, {
		header: getCommonTranslation('SCHOLARSHIP_STATUS'),
		dataIndex: 'scholarshipStatus',
		flex: 1,
		renderer: function(value, meta, record) {
        	if(!isNullOrEmpty(value) && value) {
        		return "<span style = 'color:#009e0f;'>Active</span>";
			}
        	else {
				return "<span style = 'color:#cc0000;'>InActive</span>";
			}                     
        }
	}, {
		header: getCommonTranslation('NO_OF_AWARDEES'),
		dataIndex: 'scholarshipAwardees',
		renderer: function(value, meta, record) {
        	if(!isNullOrEmpty(value) && value != 0) {
        		return '<a href="#">'+value+'</a>';
			}
        	else if(!isNullOrEmpty(value) && value == 0) {
        		return value;
			}
        	else {
				return "-";
			}                     
        }
	}, {
		header: getCommonTranslation('ELIGIBILITY_CRITERIA'),
		dataIndex: 'droolAgenda',
	    hidden: true
	}]
});