/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.survey.createSurvey.CreateSurveyViewWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.createsurveyviewwindow',
    modal: true,
    resizable: true,
    autoScroll: true,
    frame: true,
    title: getCommonTranslation('VIEW'),
    width: 600,
    height: 350,
    items: [{
        xtype: 'form',
        itemId: 'surveyViewForm',
        layout: 'vbox',
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 252
            },
            items: [{
                xtype: 'displayfield',
                name: 'sid',
                fieldLabel: getCommonTranslation('SURVEY_ID')
            }, {
                xtype: 'displayfield',
                name: 'surveyls_title',
                fieldLabel: getCommonTranslation('SURVEY_NAME')
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 252
            },
            items: [{
                xtype: 'displayfield',
                name: 'startdate',
                fieldLabel: getCommonTranslation('START_DATE')
            }, {
                xtype: 'displayfield',
                name: 'expires',
                fieldLabel: getCommonTranslation('END_DATE')
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 252
            },
            items: [{
                xtype: 'displayfield',
                name: 'anonymous',
                fieldLabel: getCommonTranslation('ANONYMOUS')
            }, {
                xtype: 'displayfield',
                name: 'active',
                fieldLabel: getCommonTranslation('STATUS')
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
        }]
    }]

});