Ext.define('Academia.view.survey.surveyReport.SurveyReportFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.surveyreportfilter',
    plugins : "formlabelrequired",
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 446,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
            itemId: 'activeSurveyListSurveyReportComboItemId',
            name:'activeSurveyListSurveyReportCombo',
            store: Ext.create('Academia.store.survey.SpecificSurveyListStore'),	    
            valueField:'surveyId',
            displayField:'surveyName',
            editable:false,
            readOnly: false,
			fieldLabel: getCommonTranslation('SURVEY_NAME'),
			allowBlank: false,
			matchFieldWidth:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
			},
			listeners:{
				afterrender: function(combo) {
		            // Ensure that the store is loaded and ready
		            var store = combo.getStore();
		            
		            // Check if the store has not been loaded yet
		            if (store) {
		                store.on('beforeload', function(store) {
		                    store.getProxy().extraParams = {
		                        isCourse: true // Pass additional params before loading
		                    };
		                });
		            }
		        }
			}
        }]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'surveyReportSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'surveyReportResetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});