/**
 * @author Pritam.Patil
 * This is Common Basic search Form
 */
Ext.define('Academia.view.systemUsage.SystemUsageCommonSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.systemusagecommonsearchform',
	method : 'POST',
	standardSubmit : false,
	frame:false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'radiofield',
            boxLabel: getCommonTranslation('ACADEMY_LOCATIONS'),
            name: 'academyLocation',
            itemId: 'academyLocation',
            checked : true
        }]},
    	
    	{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
    	xtype:'multiselectcombofield',
        fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
        width: 960,
        height:58,
        itemId : 'multiselectAcademyLocationId',
        name: 'ACADEMY_LOCATION_IDS',
        store:'common.AcademyLocationNameSeparated',
        cls:'multiBrandCampusCls',
		valueField : 'id',
		displayField : 'value',
		editable:false,
		forceSelection :true,
		allowBlank:false,
		maxLength:15000,
		height:58,
		style :{
			  marginLeft: '0px'
		},
		autoloadStore: false,
		queryMode:'local',
		  listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			  loadingText: getCommonTranslation('SEARCHING'),
              emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
              getInnerTpl: function() {
                  return '<div class="search-item">' +
                  '{value}'  +
                  '</div>';
              }}
    }]
}, {
    xtype: 'button',
    text: getCommonTranslation('CLEAR_SEARCH'),
    itemId: 'academylocationclearsearch',
    buttonAlign: 'right',
    ui: 'CustomBtnCancel',
    scale: CONSTANTS.BUTTONSIZE
    //formBind : true
}/*,{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('FROM_DATE'),
            name: 'FROM_DATE',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'fromDate',
            vtype: 'daterange',
            endDateField: 'toDate'
        }, {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('TO_DATE'),
            name: 'TO_DATE',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'toDate',
            vtype: 'daterange',
            startDateField: 'fromDate'
        }]}*/]
});