/**
 * @author Deepak Sharma
 * This component is used for Transport -> Vehicle Type Grid
 */
Ext.define('Academia.view.transport.stopLocation.StopLocationGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.stoplocationgrid',
    store : 'transport.stopLocation.StopLocationStore',
    border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'stoplocationstructure':1
		}
	},
    title: getCommonTranslation('STOP_LOCATION'),
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.stopLocation.StopLocationStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'

    }],
    columns: [{
        header: getCommonTranslation('STOP_LOCATION_CODE'),
        dataIndex: 'locationCode',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('STOP_LOCATION'),
        dataIndex: 'locationName',
        sortable: true,
        flex: .2
    }]
});