/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.transport.vehicle.InsuranceHistoryDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.insurancehistorydetailwin',
	title: getTransportTranslation('INSURANCE_DETAIL'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'insurancehistorydetailwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'insuredBy',
				itemId:'insuredBy',
				fieldLabel: getTransportTranslation('INSURED_BY'),
				maxLength:100,
				enforceMaxLength : true,
			},{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('POLICY_HOLDER_NAME'),
				name: 'policyHolderName',
				itemId:'policyHolderName',
				maxLength:255,
				enforceMaxLength : true,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{	
				xtype: 'textfield',
				name: 'policyNumber',
				itemId:'policyNumber',
				fieldLabel: getTransportTranslation('POLICY_NUMBER'),
				maxLength:255,
				enforceMaxLength : true,
			},{
				xtype: 'datefield',
				name: 'inceptionDate',
				itemId:'inceptionDate',
				fieldLabel: getTransportTranslation('INCEPTION_DATE'),
				vtype: 'daterange',
				maxValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'validFrom',
				itemId:'validFrom',
		        endDateField: 'validTill',
		        maxValue: new Date(),
		        allowBlank : false,
				fieldLabel: getTransportTranslation('INSURANCE_VALID_FROM'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					select: function(field, value, e) {
						e.blur(field);
					},
					blur: function(field) {
						var insuranceValidFrom = field;
						var insuranceValidTill = field.up().down('#validTill').getValue();
						var currentDate = new Date();
						currentDate.setHours(0);
						currentDate.setMinutes(0);
						currentDate.setSeconds(0);
						if (!isNullOrEmpty(insuranceValidTill)) {
							if (insuranceValidTill >= currentDate) {
								insuranceValidFrom.setMaxValue(currentDate);
							} else {
								insuranceValidFrom.setMaxValue(insuranceValidTill);
							}
						} else {
							insuranceValidFrom.setMaxValue(currentDate);
						}
					}
				},
				vtype: 'daterange',
			},{
				xtype: 'datefield',
				name: 'validTill',
				itemId:'validTill',
				allowBlank : false,
				fieldLabel: getTransportTranslation('INSURANCE_VALID_TILL'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					blur: function(field) {
						var insuranceValidFrom = field.up().down('#validFrom');
						var insuranceValidTill = field.getValue();
						var currentDate = new Date();
						currentDate.setHours(0);
						currentDate.setMinutes(0);
						currentDate.setSeconds(0);
						if (!isNullOrEmpty(insuranceValidTill)) {
							if (insuranceValidTill >= currentDate) {
								insuranceValidFrom.setMaxValue(currentDate);
							} else {
								insuranceValidFrom.setMaxValue(insuranceValidTill);
							}
						} else {
							insuranceValidFrom.setMaxValue(currentDate);
						}
					}
				},
				startDateField: 'validFrom',
				vtype: 'daterange',
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'insuranceCurrency',
				itemId:'insuranceCurrency',
				fieldLabel: getTransportTranslation('INSURANCE_CURRENCY'),
				store: 'organization.BaseCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank: true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'numberfield',
				name: 'insuranceCost',
				itemId:'insuranceCost',
				fieldLabel: getTransportTranslation('INSURANCE_COST'),
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowDecimals:true,
				allowExponential:false,
				minValue:0,
				maxLength: 8,				
				enforceMaxLength: true,
		        keyNavEnabled: false,
		        decimalPrecision : 2 
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
					xtype: 'customcombobox',
					name:'premiumPaymentCycle',
					itemId:'premiumPaymentCycle',
					fieldLabel:getTransportTranslation('PREMIUM_PAYMENT_CYCLE'),
					store: 'transport.vehicle.MonthlyAnnualStore',
					valueField: 'name',
					displayField: 'value',
					allowBlank:true,
					typeAhead:true,
					reference: 'fiddleCombo',
					forceSelection:true,
					enableKeyEvents:true,
					editable: false,
					trigger1Cls: 'x-form-clear-trigger', 
					trigger2Cls: 'x-form-arrow-trigger',
					onTrigger1Click: function() { this.clearValue(); },
				},{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('INSURANCE_POLICY_WITH'),
				name: 'insurancePolicyWith',
				itemId:'insurancePolicyWith',
				maxLength:100,
				enforceMaxLength : true,
			}/*,{
				xtype: 'datefield',
				name: 'insurancePaidOn',
				itemId:'insurancePaidOn',
				fieldLabel: getTransportTranslation('INSURANCE_PAID_ON'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			}*/]
		},{
			xtype:'fieldcontainer',
			labelSeparator : ':',
			fieldLabel: getTransportTranslation('BROKER_CONTACT_NO'),
			itemId:'brokerMobileCoutryCodeContainer',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: Ext.create('Academia.store.common.CountryStore'),
				itemId:'brokerMobileCountryCode',
				triggerAction: 'all',
				name: 'brokerMobileCountryCode',
				width: 80,
				forceSelection:true,
				emptyText: 'Code', 
				minChars: 1
			},{
				xtype: 'numberfield',
				name:'brokerMobileNumber',
				itemId:'brokerMobileNumber',
				minLength: 6,
				maxLength: 11,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				enforceMaxLength : true,
				width:135
			}]
			},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});